/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.xml;

import com.atlassian.jira.util.dbc.Assertions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class JiraFileInputStream
extends InputStream {
    public static final byte[] UTF32BEBOMBYTES = new byte[]{0, 0, -2, -1};
    public static final byte[] UTF32LEBOMBYTES = new byte[]{-1, -2, 0, 0};
    public static final byte[] UTF16BEBOMBYTES = new byte[]{-2, -1};
    public static final byte[] UTF16LEBOMBYTES = new byte[]{-1, -2};
    public static final byte[] UTF8BOMBYTES = new byte[]{-17, -69, -65};
    public static final byte[][] BOMBYTES = new byte[][]{UTF32BEBOMBYTES, UTF32LEBOMBYTES, UTF16BEBOMBYTES, UTF16LEBOMBYTES, UTF8BOMBYTES};
    public static final int NONE = -1;
    public static final int MAXBOMBYTES = 4;
    private final InputStream daStream;
    private final long size;

    public JiraFileInputStream(File file, String zipEntryName) throws IOException {
        long skipped;
        Assertions.notNull((String)"file", (Object)file);
        int BOMType = this.getBOMType(file, zipEntryName);
        int skipBytes = this.getSkipBytes(BOMType);
        Pair pair = JiraFileInputStream.getFileInputStream(file, zipEntryName);
        InputStream fIn = pair.stream;
        if (skipBytes <= 0 || (skipped = fIn.skip(skipBytes)) < (long)skipBytes) {
            // empty if block
        }
        this.daStream = fIn;
        this.size = pair.size;
    }

    @Override
    public int read() throws IOException {
        return this.daStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.daStream.read(b, off, len);
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        this.daStream.close();
    }

    private static boolean zipFileHasExactlyOneEntry(ZipFile file) {
        Enumeration entries = file.getEntries();
        if (entries.hasMoreElements()) {
            entries.nextElement();
            return !entries.hasMoreElements();
        }
        return false;
    }

    private static Pair getFileInputStream(File file, String zipEntryName) throws IOException {
        long size;
        InputStream is;
        FileInputStream fileInputStream = new FileInputStream(file);
        if (StringUtils.stripToEmpty((String)file.getName()).endsWith(".zip")) {
            ZipFile zipFile = new ZipFile(file);
            if (JiraFileInputStream.zipFileHasExactlyOneEntry(zipFile)) {
                ZipArchiveEntry entry = (ZipArchiveEntry)zipFile.getEntries().nextElement();
                is = JiraFileInputStream.getInputStreamForEntry(zipFile, file.getPath(), entry);
                size = entry.getSize();
            } else {
                ZipArchiveEntry entry = zipFile.getEntry(zipEntryName);
                if (entry == null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException ignored) {
                        LoggerFactory.getLogger(JiraFileInputStream.class).warn("Unable to cleanly close '" + file.getPath() + "'.", (Throwable)ignored);
                    }
                    throw new IOException(String.format("Unable to find JIRA backup (%s) inside of zip file: %s", "entities.xml", file));
                }
                is = JiraFileInputStream.getInputStreamForEntry(zipFile, file.getPath(), entry);
                size = entry.getSize();
            }
        } else {
            is = new BufferedInputStream(fileInputStream);
            size = file.length();
        }
        return new Pair(size, is);
    }

    private static InputStream getInputStreamForEntry(final ZipFile zipFile, final String path, ZipArchiveEntry entry) throws IOException {
        return new FilterInputStream(zipFile.getInputStream(entry)){

            @Override
            public void close() throws IOException {
                try {
                    this.in.close();
                }
                finally {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(JiraFileInputStream.class).warn("Unable to cleanly close '" + path + "'.", (Throwable)e);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBOMType(File _f, String zipEntryName) throws IOException {
        InputStream fileInputStream = JiraFileInputStream.getFileInputStream(_f, zipEntryName).stream;
        try {
            byte[] buff = new byte[4];
            int read = fileInputStream.read(buff);
            fileInputStream.close();
            fileInputStream = null;
            int n = this.getBOMType(buff, read);
            return n;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    private int getSkipBytes(int bomType) {
        if (bomType < 0 || bomType >= BOMBYTES.length) {
            return 0;
        }
        return BOMBYTES[bomType].length;
    }

    private int getBOMType(byte[] _bomBytes, int _length) {
        for (int i = 0; i < BOMBYTES.length; ++i) {
            for (int j = 0; j < _length && j < BOMBYTES[i].length && _bomBytes[j] == BOMBYTES[i][j]; ++j) {
                if (_bomBytes[j] != BOMBYTES[i][j] || j != BOMBYTES[i].length - 1) continue;
                return i;
            }
        }
        return -1;
    }

    private static class Pair {
        private final long size;
        private final InputStream stream;

        private Pair(long size, InputStream stream) {
            this.size = size;
            this.stream = stream;
        }
    }
}

