/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.thread;

import com.atlassian.jira.cache.JiraVCacheInitialisationUtils;
import com.atlassian.jira.cache.request.RequestCacheController;
import com.atlassian.jira.event.operation.SpanningOperationHolderImpl;
import com.atlassian.jira.instrumentation.DefaultInstrumentationListenerManager;
import com.atlassian.jira.issue.index.ThreadLocalSearcherCache;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.jira.web.filters.ThreadLocalQueryProfiler;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.TransactionUtil;

public class JiraThreadLocalUtils {
    private static final Logger log = Logger.getLogger(JiraThreadLocalUtils.class);

    public static void preCall() {
        JiraVCacheInitialisationUtils.initVCache(JiraVCacheInitialisationUtils.getFakeTenant());
        ThreadLocalSearcherCache.startSearcherContext();
        DefaultInstrumentationListenerManager.startContext(Thread.currentThread().getName());
        JiraAuthenticationContextImpl.clearRequestCache();
        SpanningOperationHolderImpl.clearContext();
        RequestCacheController.startContext();
        ThreadLocalQueryProfiler.start();
    }

    public static void postCall() {
        JiraThreadLocalUtils.postCall(log, null);
    }

    public static Runnable wrap(Runnable runnable) {
        return () -> {
            JiraThreadLocalUtils.preCall();
            try {
                runnable.run();
            }
            finally {
                JiraThreadLocalUtils.postCall();
            }
        };
    }

    public static <T> Callable<T> wrap(Callable<T> callable) {
        return () -> {
            JiraThreadLocalUtils.preCall();
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                JiraThreadLocalUtils.postCall();
            }
        };
    }

    public static void postCall(@Nonnull Logger log, @Nullable JiraThreadLocalUtil.WarningCallback warningCallback) {
        block8: {
            ThreadLocalQueryProfiler.end();
            if (!ImportUtils.isIndexIssues()) {
                log.error((Object)"Indexing thread local not cleared. Clearing...");
                ImportUtils.setIndexIssues((boolean)true);
            }
            try {
                if (TransactionUtil.getLocalTransactionConnection() == null) break block8;
                try {
                    if (warningCallback != null) {
                        warningCallback.onOpenTransaction();
                    } else {
                        log.error((Object)"Uncommitted database transaction detected.  Closing...");
                    }
                }
                finally {
                    TransactionUtil.closeAndClearThreadLocalConnection();
                }
            }
            catch (Exception t) {
                log.error((Object)"Error while inspecting transaction thread local.", (Throwable)t);
            }
        }
        RequestCacheController.closeContext();
        SpanningOperationHolderImpl.clearContext();
        DefaultInstrumentationListenerManager.endContext();
        ThreadLocalSearcherCache.stopAndCloseSearcherContext();
        JiraVCacheInitialisationUtils.cleanupVCache();
    }
}

