/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.check;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.system.check.I18nMessage;
import com.atlassian.jira.util.system.check.JRA10145Check;
import com.atlassian.jira.util.system.check.JRA12525Check;
import com.atlassian.jira.util.system.check.JRA15731Check;
import com.atlassian.jira.util.system.check.JRA18659Check;
import com.atlassian.jira.util.system.check.JRA20617Check;
import com.atlassian.jira.util.system.check.JRA21205Check;
import com.atlassian.jira.util.system.check.JRA21845Check;
import com.atlassian.jira.util.system.check.JRA24857Check;
import com.atlassian.jira.util.system.check.JVMCheck;
import com.atlassian.jira.util.system.check.SystemEnvironmentCheck;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SystemEnvironmentChecklist {
    private static final JiraProperties jiraSystemProperties = JiraSystemProperties.getInstance();
    private static final SystemEnvironmentCheck[] ENVIRONMENT_CHECKS = new SystemEnvironmentCheck[]{new JVMCheck(jiraSystemProperties), new JRA12525Check(), new JRA10145Check(jiraSystemProperties), new JRA18659Check(jiraSystemProperties), new JRA20617Check(), new JRA21205Check(), new JRA15731Check(), new JRA21845Check(), new JRA24857Check()};
    private static List<I18nMessage> warnings;

    private static List<I18nMessage> getWarnings() {
        if (warnings == null) {
            ArrayList newWarnings = Lists.newArrayList();
            for (SystemEnvironmentCheck check : ENVIRONMENT_CHECKS) {
                I18nMessage warningMessage = check.getWarningMessage();
                if (warningMessage == null) continue;
                newWarnings.add(warningMessage);
            }
            warnings = newWarnings;
        }
        return warnings;
    }

    public static List<String> getWarningMessages(Locale locale, boolean asHtml) {
        I18nBean i18nBean = new I18nBean(locale);
        List<I18nMessage> warnings = SystemEnvironmentChecklist.getWarnings();
        ArrayList translatedWarnings = Lists.newArrayListWithCapacity((int)warnings.size());
        for (I18nMessage warning : warnings) {
            String warningMessage;
            List<Object> parameters = warning.getParameters();
            if (asHtml) {
                if (warning.hasLink()) {
                    parameters.add("<a href=\"" + warning.getLink() + "\">");
                    parameters.add("</a>");
                }
                parameters.add("<em>");
                parameters.add("</em>");
                warningMessage = i18nBean.getText(warning.getKey() + ".html", parameters);
            } else {
                if (warning.hasLink()) {
                    parameters.add(warning.getLink());
                }
                warningMessage = i18nBean.getText(warning.getKey() + ".text", parameters);
            }
            translatedWarnings.add(warningMessage);
        }
        return translatedWarnings;
    }

    public static List<String> getEnglishWarningMessages() {
        return SystemEnvironmentChecklist.getWarningMessages(Locale.ENGLISH, false);
    }
}

