/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.stats;

import com.atlassian.jira.util.stats.LongStats;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;

public class MutableLongStats
implements LongConsumer {
    static final long MIN_UNSET = Long.MAX_VALUE;
    static final long MAX_UNSET = Long.MIN_VALUE;
    final AtomicLong count = new AtomicLong(0L);
    final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    final AtomicLong max = new AtomicLong(Long.MIN_VALUE);
    final AtomicLong sum = new AtomicLong(0L);

    public MutableLongStats() {
        this.reset();
    }

    @Override
    public void accept(long value) {
        this.count.incrementAndGet();
        this.min.updateAndGet(currentMin -> value < currentMin ? value : currentMin);
        this.max.updateAndGet(currentMax -> value > currentMax ? value : currentMax);
        this.sum.addAndGet(value);
    }

    public LongStats get() {
        return LongStats.create(this);
    }

    public void reset() {
        this.count.set(0L);
        this.min.set(Long.MAX_VALUE);
        this.max.set(Long.MIN_VALUE);
        this.sum.set(0L);
    }

    public void merge(LongStats longStats) {
        this.count.addAndGet(longStats.count);
        this.min.updateAndGet(currentValue -> longStats.min < currentValue ? longStats.min : currentValue);
        this.max.updateAndGet(currentValue -> longStats.max > currentValue ? longStats.max : currentValue);
        this.sum.addAndGet(longStats.sum);
    }
}

