/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.mime;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeManager {
    private static final List<String> GENERIC_MIME_TYPES = ImmutableList.of((Object)"application/octet-stream", (Object)"application/x-zip-compressed");
    private static final Logger log = LoggerFactory.getLogger(MimeManager.class);
    private final String DEFAULT_MIME_TYPE = "text/html";
    private FileTypeMap fileTypeMap;

    public MimeManager(InputStream mimeTypesInputStream) {
        if (mimeTypesInputStream == null) {
            this.fileTypeMap = new MimetypesFileTypeMap();
            log.info("mimeTypesInputStream was null. Loading default mimeTypes");
        } else {
            try {
                this.fileTypeMap = new MimetypesFileTypeMap(mimeTypesInputStream);
            }
            catch (Exception e) {
                log.error("Could not load mimeTypes from inputStream.  Defaulting to default mimeTypes", (Throwable)e);
                this.fileTypeMap = new MimetypesFileTypeMap();
            }
            finally {
                try {
                    mimeTypesInputStream.close();
                }
                catch (IOException e) {
                    log.warn("Could not close mime types inputStream");
                }
            }
        }
    }

    public String getSanitisedMimeType(String existingMimeType, String fileName) {
        if (GENERIC_MIME_TYPES.contains(existingMimeType)) {
            return this.getSuggestedMimeType(fileName);
        }
        return existingMimeType;
    }

    public String getSuggestedMimeType(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (!fileName.contains(".")) {
            return "text/html";
        }
        return this.fileTypeMap.getContentType(fileName.toLowerCase(Locale.US));
    }
}

