/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.johnson;

import com.atlassian.jira.util.johnson.JiraJohnsonContainer;
import com.atlassian.jira.util.johnson.JohnsonEventPredicates;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultJiraJohnsonContainer
implements JiraJohnsonContainer {
    private final JohnsonEventContainer delegate;

    public DefaultJiraJohnsonContainer(JohnsonEventContainer delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public Collection<Event> getEventsThatPreventStartup() {
        return this.stream().filter(JohnsonEventPredicates.blocksStartup()).collect(Collectors.toList());
    }

    public void addEvent(Event event) {
        this.delegate.addEvent(event);
    }

    public void clear() {
        this.delegate.clear();
    }

    @Nonnull
    public Collection<Event> getEvents() {
        return this.delegate.getEvents();
    }

    public boolean hasEvents() {
        return this.delegate.hasEvents();
    }

    public void removeEvent(Event event) {
        this.delegate.removeEvent(event);
    }

    @Nonnull
    public Stream<Event> stream() {
        return this.delegate.stream();
    }

    public Collection<Event> getEvents(Predicate<? super Event> predicate) {
        return this.delegate.getEvents(predicate);
    }

    public boolean hasEvent(Predicate<? super Event> predicate) {
        return this.delegate.hasEvent(predicate);
    }

    public Optional<Event> firstEvent(Predicate<? super Event> predicate) {
        return this.delegate.firstEvent(predicate);
    }
}

