/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.compression;

import com.atlassian.jira.util.compression.AbstractArchiveCompressor;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.xerial.snappy.SnappyFramedOutputStream;

class SnappyArchiveCompressor
extends AbstractArchiveCompressor {
    SnappyArchiveCompressor(File file) throws IOException, ArchiveException {
        super(SnappyArchiveCompressor.createArchiveOutputStream(file));
    }

    @Override
    ArchiveEntry createArchiveEntry(File file, String name) {
        return new TarArchiveEntry(file, name);
    }

    @VisibleForTesting
    static ArchiveOutputStream createArchiveOutputStream(File output) throws IOException {
        TarArchiveOutputStream archiveOutputStream = new TarArchiveOutputStream((OutputStream)new SnappyFramedOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(output))));
        archiveOutputStream.setBigNumberMode(2);
        archiveOutputStream.setLongFileMode(3);
        return archiveOutputStream;
    }
}

