/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.Streams;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class JiraCollectionUtils {
    public static String[] stringCollectionToStringArray(Collection<String> allValues) {
        return allValues.toArray(new String[allValues.size()]);
    }

    public static <T> Collection<T> convertIterableToCollection(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        return Streams.stream(iterable).collect(Collectors.toList());
    }

    public static <T> Stream<T> streamFromOptional(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }

    @Nonnull
    public static <T> List<T> listify(@Nonnull Optional<T> optional) {
        return optional.map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private JiraCollectionUtils() {
    }
}

