/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.google.common.base.Function;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DefaultBaseUrl
implements BaseUrl {
    private final VelocityRequestContextFactory factory;

    public DefaultBaseUrl(VelocityRequestContextFactory factory) {
        this.factory = factory;
    }

    @Override
    @Nonnull
    public String getBaseUrl() {
        return StringUtils.trimToEmpty((String)this.factory.getJiraVelocityRequestContext().getBaseUrl());
    }

    @Override
    @Nonnull
    public String getCanonicalBaseUrl() {
        return StringUtils.trimToEmpty((String)this.factory.getJiraVelocityRequestContext().getCanonicalBaseUrl());
    }

    @Override
    public URI getBaseUri() {
        String baseUrl = this.getCanonicalBaseUrl();
        if (baseUrl == null) {
            throw new IllegalStateException("The JIRA Base URL has not been set, you can set this by navigating to the Administration --> General Configuration page");
        }
        URI baseUri = URI.create(baseUrl + "/");
        if (!baseUri.isAbsolute()) {
            throw new IllegalStateException("The JIRA base URL needs to be absolute");
        }
        return baseUri;
    }

    @Override
    @Nullable
    public <I, O> O runWithStaticBaseUrl(@Nullable I input, @Nonnull Function<I, O> runnable) {
        return (O)this.factory.runWithStaticBaseUrl(input, runnable);
    }
}

