/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.DelegatorInterface;

public class UserKeyStoreImpl
implements UserKeyStore {
    private final EntityEngine entityEngine;
    private final OfBizDelegator ofBizDelegator;
    private final DelegatorInterface delegatorInterface;
    private final Cache<String, Optional<ApplicationUserEntity>> keyToUserCache;
    private final Cache<String, Optional<ApplicationUserEntity>> usernameToUserCache;
    private final Cache<Long, Optional<ApplicationUserEntity>> idToUserCache;
    private static final Pattern ID_BASED_USERKEY_PATTERN = Pattern.compile("^JIRAUSER[0-9]+$");
    private static final Pattern USERNAME_COLLISION_USERKEY_PATTERN = Pattern.compile("^ID[0-9]+$");

    public UserKeyStoreImpl(EntityEngine entityEngine, OfBizDelegator ofBizDelegator, DelegatorInterface delegatorInterface, EventPublisher eventPublisher, CacheManager cacheManager) {
        this.entityEngine = entityEngine;
        this.ofBizDelegator = ofBizDelegator;
        this.delegatorInterface = delegatorInterface;
        this.keyToUserCache = cacheManager.getCache(UserKeyStoreImpl.class.getName() + ".keyToUserCache", key -> Optional.ofNullable(Select.from(Entity.APPLICATION_USER).whereEqual("userKey", (String)key).runWith(entityEngine).singleValue()));
        this.usernameToUserCache = cacheManager.getCache(UserKeyStoreImpl.class.getName() + ".usernameToUserCache", username -> Optional.ofNullable(Select.from(Entity.APPLICATION_USER).whereEqual("lowerUserName", (String)username).runWith(entityEngine).singleValue()));
        this.idToUserCache = cacheManager.getCache(UserKeyStoreImpl.class.getName() + ".idToUserCache", id -> Optional.ofNullable(Select.from(Entity.APPLICATION_USER).whereEqual("id", (Long)id).runWith(entityEngine).singleValue()));
        this.buildCache();
        eventPublisher.register((Object)this);
    }

    @Override
    public String getUsernameForKey(String userKey) {
        return this.getUserForKey(userKey).map(ApplicationUserEntity::getUsername).orElse(null);
    }

    @Override
    public String getKeyForUsername(String username) {
        return this.getUserForUsername(username).map(ApplicationUserEntity::getKey).orElse(null);
    }

    @Override
    public Long getIdForUserKey(String userKey) {
        return this.getUserForKey(userKey).map(ApplicationUserEntity::getId).orElse(null);
    }

    @Override
    public Optional<ApplicationUserEntity> getUserForId(Long id) {
        return UserKeyStoreImpl.fromCache(this.idToUserCache, id);
    }

    @Override
    public Optional<ApplicationUserEntity> getUserForKey(String key) {
        return UserKeyStoreImpl.fromCache(this.keyToUserCache, key);
    }

    @Override
    public Optional<ApplicationUserEntity> getUserForUsername(String username) {
        return UserKeyStoreImpl.fromCache(this.usernameToUserCache, IdentifierUtils.toLowerCase((String)username));
    }

    @Override
    public void renameUser(String oldUsername, String newUsername) {
        oldUsername = IdentifierUtils.toLowerCase((String)oldUsername);
        newUsername = IdentifierUtils.toLowerCase((String)newUsername);
        ApplicationUserEntity user = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual("lowerUserName", oldUsername).runWith(this.ofBizDelegator).singleValue();
        if (user == null) {
            throw new IllegalStateException("Trying to rename user '" + oldUsername + "' but no user key is mapped.");
        }
        this.entityEngine.execute(Update.into(Entity.APPLICATION_USER).set("lowerUserName", newUsername).whereEqual("userKey", user.getKey()));
        this.keyToUserCache.remove((Object)user.getKey());
        this.usernameToUserCache.remove((Object)newUsername);
        this.usernameToUserCache.remove((Object)oldUsername);
        this.idToUserCache.remove((Object)user.getId());
    }

    @Override
    public String ensureUniqueKeyForNewUser(String username) {
        String lowerUsername = IdentifierUtils.toLowerCase((String)((String)Assertions.notNull((String)"username", (Object)username)));
        ApplicationUserEntity applicationUserEntity = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual("lowerUserName", lowerUsername).runWith(this.entityEngine).singleValue();
        if (applicationUserEntity != null) {
            return applicationUserEntity.getKey();
        }
        if (((FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)).isEnabled(JiraFeatureFlagRegistrar.DB_ID_BASED_KEY_GENERATION_STRATEGY)) {
            return this.newKeyGenerationStrategy(lowerUsername);
        }
        return this.oldKeyGenerationStrategy(lowerUsername);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String removeByKey(String key) {
        if (key == null) {
            return null;
        }
        try {
            ApplicationUserEntity user = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual("userKey", key).runWith(this.entityEngine).singleValue();
            if (user != null) {
                Delete.from(Entity.APPLICATION_USER).whereEqual("userKey", key).execute(this.entityEngine);
                this.usernameToUserCache.remove((Object)user.getUsername());
                this.idToUserCache.remove((Object)user.getId());
                String string = user.getUsername();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.keyToUserCache.remove((Object)key);
        }
    }

    @Override
    public boolean isSystemKey(@Nonnull String key) {
        return ID_BASED_USERKEY_PATTERN.matcher(key).matches() || USERNAME_COLLISION_USERKEY_PATTERN.matcher(key).matches();
    }

    @Override
    @Nonnull
    public String getKeyFromId(long id) {
        return "JIRAUSER" + id;
    }

    @Override
    public void changeKey(@Nonnull String oldUserKey, @Nonnull String newUserKey) {
        Optional<ApplicationUserEntity> user = this.getUserForKey(oldUserKey);
        if (!user.isPresent()) {
            throw new IllegalStateException("Trying to change user key '" + oldUserKey + "' but no user with this key is present.");
        }
        Optional<ApplicationUserEntity> destinationUser = this.getUserForKey(newUserKey);
        if (destinationUser.isPresent()) {
            throw new IllegalStateException("Trying to change user key '" + oldUserKey + "' to '" + newUserKey + "' but user with this key is already present.");
        }
        int updated = this.entityEngine.execute(Update.into(Entity.APPLICATION_USER).set("userKey", newUserKey).whereEqual("userKey", oldUserKey));
        if (updated == 0) {
            throw new IllegalStateException("No rows updated when trying to change user key '" + oldUserKey + "' to '" + newUserKey + "'.");
        }
        this.keyToUserCache.remove((Object)user.get().getKey());
        this.keyToUserCache.remove((Object)newUserKey);
        this.usernameToUserCache.remove((Object)user.get().getUsername());
        this.idToUserCache.remove((Object)user.get().getId());
    }

    private void buildCache() {
        List users = Select.from(Entity.APPLICATION_USER).runWith(this.entityEngine).asList();
        for (ApplicationUserEntity user : users) {
            Optional<ApplicationUserEntity> cacheValue = Optional.of(user);
            this.keyToUserCache.put((Object)user.getKey(), cacheValue);
            this.usernameToUserCache.put((Object)user.getUsername(), cacheValue);
            this.idToUserCache.put((Object)user.getId(), cacheValue);
        }
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.keyToUserCache.removeAll();
        this.usernameToUserCache.removeAll();
        this.idToUserCache.removeAll();
        this.buildCache();
    }

    private static <K, V> Optional<V> fromCache(Cache<K, Optional<V>> cache, K key) {
        return key != null ? (Optional)cache.get(key) : Optional.empty();
    }

    private String newKeyGenerationStrategy(@Nonnull String lowerUsername) {
        Long id = this.delegatorInterface.getNextSeqId(Entity.APPLICATION_USER.getEntityName());
        String userKey = this.getKeyFromId(id);
        return this.storeMapping(userKey, lowerUsername, id);
    }

    private String oldKeyGenerationStrategy(@Nonnull String lowerUsername) {
        ApplicationUserEntity applicationUserEntity = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual("userKey", lowerUsername).runWith(this.entityEngine).singleValue();
        if (applicationUserEntity == null) {
            return this.storeMapping(lowerUsername, lowerUsername);
        }
        Long id = this.delegatorInterface.getNextSeqId(Entity.APPLICATION_USER.getEntityName());
        String userKey = "ID" + id;
        return this.storeMapping(userKey, lowerUsername, id);
    }

    private String storeMapping(@Nonnull String userKey, @Nonnull String lowerUsername) {
        return this.storeMapping(userKey, lowerUsername, null);
    }

    private String storeMapping(@Nonnull String userKey, @Nonnull String lowerUsername, @Nullable Long id) {
        FieldMap fieldValues = FieldMap.build((String)"userKey", (Object)userKey).add("lowerUserName", (Object)lowerUsername);
        if (id != null) {
            fieldValues.add("id", (Object)id);
        }
        this.ofBizDelegator.createValue(Entity.APPLICATION_USER.getEntityName(), (Map)fieldValues);
        this.usernameToUserCache.remove((Object)lowerUsername);
        this.keyToUserCache.remove((Object)userKey);
        return userKey;
    }
}

