/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.ExperimentalApi;
import java.util.Objects;
import javax.annotation.Nonnull;

@ExperimentalApi
@EventName(value="jira.user.key.changed")
public class UserKeyChangedEvent {
    private final String oldUserKey;
    private final String newUserKey;

    public UserKeyChangedEvent(@Nonnull String oldUserKey, @Nonnull String newUserKey) {
        this.oldUserKey = Objects.requireNonNull(oldUserKey);
        this.newUserKey = Objects.requireNonNull(newUserKey);
    }

    @Nonnull
    public String getOldUserKey() {
        return this.oldUserKey;
    }

    @Nonnull
    public String getNewUserKey() {
        return this.newUserKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserKeyChangedEvent that = (UserKeyChangedEvent)o;
        return Objects.equals(this.oldUserKey, that.oldUserKey) && Objects.equals(this.newUserKey, that.newUserKey);
    }

    public int hashCode() {
        return Objects.hash(this.oldUserKey, this.newUserKey);
    }
}

