/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandlerModuleDescriptor;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ExperimentalApi
public interface UserKeyChangeService {
    @Nonnull
    public UserKeyChangeValidationResult validateUserKeyChange(@Nonnull UserKeyChangeRequest var1);

    @Nonnull
    public UserKeyChangeAffectedEntitiesResult getAffectedEntities(@Nonnull UserKeyChangeRequest var1);

    @Nonnull
    public UserKeyChangeResult userKeyChange(@Nonnull UserKeyChangeValidationResult var1);

    public int getHandlersCount();

    @ExperimentalApi
    public static class UserKeyChangeResult
    extends ServiceResultImpl {
        private final Map<UserKeyChangeHandlerModuleDescriptor, ErrorCollection> warnings;

        public UserKeyChangeResult(@Nonnull ErrorCollection errorCollection, @Nonnull Map<UserKeyChangeHandlerModuleDescriptor, ErrorCollection> warnings) {
            super(errorCollection);
            this.warnings = Objects.requireNonNull(warnings);
        }

        public UserKeyChangeResult(@Nonnull Map<UserKeyChangeHandlerModuleDescriptor, ErrorCollection> warnings) {
            super((ErrorCollection)new SimpleErrorCollection());
            this.warnings = Objects.requireNonNull(warnings);
        }

        public Map<UserKeyChangeHandlerModuleDescriptor, ErrorCollection> getWarnings() {
            return this.warnings;
        }
    }

    @ExperimentalApi
    public static class UserKeyChangeAffectedEntitiesResult
    extends ServiceResultImpl {
        private final Collection<AffectedEntity> affectedEntities;
        private final Map<UserKeyChangeHandlerModuleDescriptor, ErrorCollection> warnings;

        public UserKeyChangeAffectedEntitiesResult(@Nonnull Collection<AffectedEntity> affectedEntities, @Nonnull Map<UserKeyChangeHandlerModuleDescriptor, ErrorCollection> warnings) {
            super((ErrorCollection)new SimpleErrorCollection());
            this.affectedEntities = Objects.requireNonNull(affectedEntities);
            this.warnings = Objects.requireNonNull(warnings);
        }

        public UserKeyChangeAffectedEntitiesResult(@Nonnull ErrorCollection errorCollection) {
            super(errorCollection);
            this.affectedEntities = ImmutableList.of();
            this.warnings = new HashMap<UserKeyChangeHandlerModuleDescriptor, ErrorCollection>();
        }

        @Nonnull
        public Collection<AffectedEntity> getAffectedEntities() {
            return this.affectedEntities;
        }

        @Nonnull
        public Map<UserKeyChangeHandlerModuleDescriptor, ErrorCollection> getWarnings() {
            return this.warnings;
        }
    }

    @ExperimentalApi
    public static class UserKeyChangeValidationResult
    extends ServiceResultImpl {
        private final UserKeyChangeRequest userKeyChangeRequest;

        UserKeyChangeValidationResult(@Nonnull UserKeyChangeRequest userKeyChangeRequest, @Nonnull ErrorCollection errorCollection) {
            super(errorCollection);
            this.userKeyChangeRequest = Objects.requireNonNull(userKeyChangeRequest);
        }

        UserKeyChangeValidationResult(@Nonnull UserKeyChangeRequest userKeyChangeRequest) {
            this(userKeyChangeRequest, (ErrorCollection)new SimpleErrorCollection());
        }

        public UserKeyChangeRequest getUserKeyChangeRequest() {
            return this.userKeyChangeRequest;
        }
    }

    @ExperimentalApi
    public static class UserKeyChangeRequest {
        private final Context context;
        private final ApplicationUser loggedInUser;
        private final UserPropertyChangeParameter userPropertyChangeParameter;

        public UserKeyChangeRequest(@Nonnull Context context, @Nullable ApplicationUser loggedInUser, @Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
            this.context = Objects.requireNonNull(context);
            this.loggedInUser = loggedInUser;
            this.userPropertyChangeParameter = Objects.requireNonNull(userPropertyChangeParameter);
        }

        @Nonnull
        public Context getContext() {
            return this.context;
        }

        @Nonnull
        public UserPropertyChangeParameter getUserPropertyChangeParameter() {
            return this.userPropertyChangeParameter;
        }

        @Nullable
        public ApplicationUser getLoggedInUser() {
            return this.loggedInUser;
        }
    }
}

