/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandlerModuleDescriptor;
import com.atlassian.jira.user.anonymize.UserKeyChangeManager;
import com.atlassian.jira.user.anonymize.UserKeyChangeService;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserKeyChangeService
implements UserKeyChangeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserKeyChangeService.class);
    private final UserManager userManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final UserKeyChangeManager userKeyChangeManager;
    private final UserKeyStore userKeyStore;

    public DefaultUserKeyChangeService(UserManager userManager, GlobalPermissionManager globalPermissionManager, I18nHelper.BeanFactory i18nFactory, UserKeyChangeManager userKeyChangeManager, UserKeyStore userKeyStore) {
        this.userManager = userManager;
        this.globalPermissionManager = globalPermissionManager;
        this.i18nFactory = i18nFactory;
        this.userKeyChangeManager = userKeyChangeManager;
        this.userKeyStore = userKeyStore;
    }

    @Override
    @Nonnull
    public UserKeyChangeService.UserKeyChangeValidationResult validateUserKeyChange(@Nonnull UserKeyChangeService.UserKeyChangeRequest userKeyChangeRequest) {
        String anonymizedUserKey;
        Optional<ApplicationUserEntity> existingUserWithDestinationKey;
        ApplicationUser loggedInUser = userKeyChangeRequest.getLoggedInUser();
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.isAdministrator(loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.no.permission"));
            return new UserKeyChangeService.UserKeyChangeValidationResult(userKeyChangeRequest, (ErrorCollection)errors);
        }
        String originalUserKey = userKeyChangeRequest.getUserPropertyChangeParameter().getOriginal();
        ApplicationUser userToUpdate = this.userManager.getUserByKeyEvenWhenUnknown(originalUserKey);
        if (!this.isSysAdmin(loggedInUser) && this.isSysAdmin(userToUpdate)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.must.be.sysadmin.to.edit.sysadmin"));
            return new UserKeyChangeService.UserKeyChangeValidationResult(userKeyChangeRequest, (ErrorCollection)errors);
        }
        if (Objects.equals(userKeyChangeRequest.getUserPropertyChangeParameter().getOriginal(), userKeyChangeRequest.getUserPropertyChangeParameter().getTarget())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.keys.equal"));
            return new UserKeyChangeService.UserKeyChangeValidationResult(userKeyChangeRequest, (ErrorCollection)errors);
        }
        if (StringUtils.isBlank((CharSequence)userKeyChangeRequest.getUserPropertyChangeParameter().getTarget())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.anonymize.key.blank"));
            return new UserKeyChangeService.UserKeyChangeValidationResult(userKeyChangeRequest, (ErrorCollection)errors);
        }
        if (userKeyChangeRequest.getLoggedInUser().getKey().equals(userKeyChangeRequest.getUserPropertyChangeParameter().getOriginal())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.yourself"));
            return new UserKeyChangeService.UserKeyChangeValidationResult(userKeyChangeRequest, (ErrorCollection)errors);
        }
        if (userToUpdate == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.user.does.not.exist", originalUserKey));
            return new UserKeyChangeService.UserKeyChangeValidationResult(userKeyChangeRequest, (ErrorCollection)errors);
        }
        if (userToUpdate.getDirectoryId() == -1L) {
            if (userToUpdate.getId().equals(-1L)) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.user.does.not.exist", originalUserKey));
                return new UserKeyChangeService.UserKeyChangeValidationResult(userKeyChangeRequest, (ErrorCollection)errors);
            }
        } else if (userToUpdate.isActive()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.user.active"));
            return new UserKeyChangeService.UserKeyChangeValidationResult(userKeyChangeRequest, (ErrorCollection)errors);
        }
        if ((existingUserWithDestinationKey = this.userKeyStore.getUserForKey(anonymizedUserKey = userKeyChangeRequest.getUserPropertyChangeParameter().getTarget())).isPresent()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.destination.key.already.exists", anonymizedUserKey));
            return new UserKeyChangeService.UserKeyChangeValidationResult(userKeyChangeRequest, (ErrorCollection)errors);
        }
        return new UserKeyChangeService.UserKeyChangeValidationResult(userKeyChangeRequest);
    }

    @Override
    @Nonnull
    public UserKeyChangeService.UserKeyChangeAffectedEntitiesResult getAffectedEntities(@Nonnull UserKeyChangeService.UserKeyChangeRequest userKeyChangeRequest) {
        UserKeyChangeService.UserKeyChangeValidationResult validationResult = this.validateUserKeyChange(userKeyChangeRequest);
        if (!validationResult.isValid()) {
            return new UserKeyChangeService.UserKeyChangeAffectedEntitiesResult(validationResult.getErrorCollection());
        }
        Map<UserKeyChangeHandlerModuleDescriptor, ServiceOutcome<Collection<AffectedEntity>>> managerResponse = this.userKeyChangeManager.getAffectedEntities(userKeyChangeRequest.getUserPropertyChangeParameter());
        Collection affectedEntities = managerResponse.values().stream().map(serviceOutcome -> (Collection)serviceOutcome.get()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        Map<UserKeyChangeHandlerModuleDescriptor, ErrorCollection> warnings = managerResponse.entrySet().stream().filter(entry -> !((ServiceOutcome)entry.getValue()).isValid()).collect(Collectors.toMap(entry -> (UserKeyChangeHandlerModuleDescriptor)((Object)((Object)entry.getKey())), entry -> ((ServiceOutcome)entry.getValue()).getErrorCollection()));
        return new UserKeyChangeService.UserKeyChangeAffectedEntitiesResult(affectedEntities, warnings);
    }

    @Override
    @Nonnull
    public UserKeyChangeService.UserKeyChangeResult userKeyChange(@Nonnull UserKeyChangeService.UserKeyChangeValidationResult userKeyChangeValidationResult) {
        Assertions.notNull((String)"You can not change user key, validation result", (Object)((Object)userKeyChangeValidationResult));
        Assertions.is((String)"You can not change user key with an invalid validation result.", (boolean)userKeyChangeValidationResult.isValid());
        Assertions.is((String)"Make sure to call validateUserKeyChange(UserKeyChangeRequest) before calling userKeyChange(UserKeyChangeValidationResult).", (userKeyChangeValidationResult.getUserKeyChangeRequest() != null ? 1 : 0) != 0);
        UserKeyChangeService.UserKeyChangeRequest userKeyChangeRequest = userKeyChangeValidationResult.getUserKeyChangeRequest();
        UserKeyChangeService.UserKeyChangeValidationResult validationResult = this.validateUserKeyChange(userKeyChangeRequest);
        if (!validationResult.isValid()) {
            return new UserKeyChangeService.UserKeyChangeResult(validationResult.getErrorCollection(), Collections.emptyMap());
        }
        I18nHelper i18nBean = this.getI18nBean(userKeyChangeRequest.getLoggedInUser());
        ErrorCollection errorCollection = this.changeUserKeyInAppUser(userKeyChangeRequest, i18nBean);
        if (!errorCollection.hasAnyErrors()) {
            Map<UserKeyChangeHandlerModuleDescriptor, ServiceResult> handlersResult = this.userKeyChangeManager.executeHandlers(userKeyChangeRequest.getUserPropertyChangeParameter(), userKeyChangeRequest.getContext(), i18nBean);
            Map<UserKeyChangeHandlerModuleDescriptor, ErrorCollection> warningMap = handlersResult.entrySet().stream().filter(entry -> !((ServiceResult)entry.getValue()).isValid()).collect(Collectors.toMap(entry -> (UserKeyChangeHandlerModuleDescriptor)((Object)((Object)entry.getKey())), entry -> ((ServiceResult)entry.getValue()).getErrorCollection()));
            return new UserKeyChangeService.UserKeyChangeResult(errorCollection, warningMap);
        }
        log.warn("User key change - processing plugin points skipped because of error in app_user user key change");
        return new UserKeyChangeService.UserKeyChangeResult(errorCollection, Collections.emptyMap());
    }

    private ErrorCollection changeUserKeyInAppUser(@Nonnull UserKeyChangeService.UserKeyChangeRequest userKeyChangeRequest, I18nHelper i18nBean) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String handlerDescription = i18nBean.getText("admin.user.key.change.handler.key.change");
        log.info("Starting task for handler: {}", (Object)handlerDescription);
        try (Context.Task task = userKeyChangeRequest.getContext().start(null);){
            userKeyChangeRequest.getContext().setName(i18nBean.getText("admin.user.key.change.processing.handler", handlerDescription));
            this.userKeyChangeManager.changeUserKey(userKeyChangeRequest.getUserPropertyChangeParameter());
            log.info("Ending task (success) for handler: {}", (Object)handlerDescription);
        }
        catch (Exception e) {
            log.error(String.format("Exception during UserKeyChangeHandler %s processing", handlerDescription), (Throwable)e);
            errorCollection.addErrorMessage(String.format("Exception during processing %s: %s", handlerDescription, e.getMessage()));
            log.info("Ending task (error) for handler: {}, ({})", (Object)handlerDescription, (Object)errorCollection);
        }
        return errorCollection;
    }

    @Override
    public int getHandlersCount() {
        return this.userKeyChangeManager.getHandlersCount() + 1;
    }

    private boolean isAdministrator(@Nullable ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private boolean isSysAdmin(@Nullable ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }

    private I18nHelper getI18nBean(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }
}

