/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandlerModuleDescriptor;
import com.atlassian.jira.user.anonymize.UserKeyChangeManager;
import com.atlassian.jira.user.anonymize.UserKeyChangedEvent;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.PluginAccessor;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserKeyChangeManager
implements UserKeyChangeManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserKeyChangeManager.class);
    private final PluginAccessor pluginAccessor;
    private final EventPublisher eventPublisher;
    private final UserKeyStore userKeyStore;

    public DefaultUserKeyChangeManager(PluginAccessor pluginAccessor, EventPublisher eventPublisher, UserKeyStore userKeyStore) {
        this.pluginAccessor = pluginAccessor;
        this.eventPublisher = eventPublisher;
        this.userKeyStore = userKeyStore;
    }

    @Override
    public void changeUserKey(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        this.userKeyStore.changeKey(userPropertyChangeParameter.getOriginal(), userPropertyChangeParameter.getTarget());
        this.eventPublisher.publish((Object)new UserKeyChangedEvent(userPropertyChangeParameter.getOriginal(), userPropertyChangeParameter.getTarget()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UserKeyChangeHandlerModuleDescriptor, ServiceOutcome<Collection<AffectedEntity>>> getAffectedEntities(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        HashMap<UserKeyChangeHandlerModuleDescriptor, ServiceOutcome<Collection<AffectedEntity>>> response = new HashMap<UserKeyChangeHandlerModuleDescriptor, ServiceOutcome<Collection<AffectedEntity>>>();
        List<UserKeyChangeHandlerModuleDescriptor> handlers = this.getModuleDescriptorsForHandlers();
        log.info("User key change handlers count: {}", (Object)handlers.size());
        for (UserKeyChangeHandlerModuleDescriptor handlerModuleDescriptor : handlers) {
            UserKeyChangeHandler handler = (UserKeyChangeHandler)handlerModuleDescriptor.getModule();
            log.info("Getting affected entities for handler: {}", (Object)handlerModuleDescriptor);
            try {
                Collection affectedEntities = this.retryOnException(() -> handler.getAffectedEntities(userPropertyChangeParameter), 1);
                response.put(handlerModuleDescriptor, ServiceOutcomeImpl.ok(affectedEntities));
            }
            catch (Exception e) {
                log.error("Exception during getting affected entities {}", (Object)handlerModuleDescriptor, (Object)e);
                response.put(handlerModuleDescriptor, ServiceOutcomeImpl.error(e.getMessage()));
            }
            finally {
                log.info("Ending getting affected entities for handler: {}", (Object)handlerModuleDescriptor);
            }
        }
        return response;
    }

    @Override
    @Nonnull
    public Map<UserKeyChangeHandlerModuleDescriptor, ServiceResult> executeHandlers(@Nonnull UserPropertyChangeParameter userKeyChangeRequest, @Nonnull Context taskContext, @Nonnull I18nHelper i18nBean) {
        HashMap<UserKeyChangeHandlerModuleDescriptor, ServiceResult> response = new HashMap<UserKeyChangeHandlerModuleDescriptor, ServiceResult>();
        List<UserKeyChangeHandlerModuleDescriptor> handlers = this.getModuleDescriptorsForHandlers();
        log.info("User key change handlers count: {}", (Object)handlers.size());
        for (UserKeyChangeHandlerModuleDescriptor handlerModuleDescriptor : handlers) {
            UserKeyChangeHandler handler = (UserKeyChangeHandler)handlerModuleDescriptor.getModule();
            log.info("Starting task for handler: {}", (Object)handlerModuleDescriptor);
            try {
                Context.Task task = taskContext.start((Object)handler);
                Throwable throwable = null;
                try {
                    taskContext.setName(i18nBean.getText("admin.user.key.change.processing.handler", handlerModuleDescriptor.getDisplayName()));
                    ServiceResult handlerResponse = this.retryOnException(() -> handler.update(userKeyChangeRequest), 1);
                    response.put(handlerModuleDescriptor, handlerResponse);
                    if (!handlerResponse.isValid()) {
                        log.info("Ending task (error) for handler: {}, ({})", (Object)handlerModuleDescriptor, (Object)handlerResponse.getErrorCollection());
                        continue;
                    }
                    log.info("Ending task (success) for handler: {}", (Object)handlerModuleDescriptor);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (task == null) continue;
                    if (throwable != null) {
                        try {
                            task.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    task.close();
                }
            }
            catch (Exception e) {
                log.error("Exception during UserKeyChangeHandler {} processing", (Object)handlerModuleDescriptor, (Object)e);
                response.put(handlerModuleDescriptor, (ServiceResult)ServiceOutcomeImpl.error(e.getMessage()));
            }
        }
        return response;
    }

    @Override
    public int getHandlersCount() {
        return this.getModuleDescriptorsForHandlers().size();
    }

    private List<UserKeyChangeHandlerModuleDescriptor> getModuleDescriptorsForHandlers() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(UserKeyChangeHandlerModuleDescriptor.class);
    }

    private <T> T retryOnException(Callable<T> callable, int retries) throws Exception {
        int attempt = 0;
        while (true) {
            try {
                return callable.call();
            }
            catch (IOException ioe) {
                IOException lastException = ioe;
                log.warn("Exception during handler execution", (Throwable)ioe);
                if (++attempt <= retries) continue;
                throw lastException;
            }
            break;
        }
    }
}

