/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.user.AnonymizeUserService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Preconditions;

public class DefaultAnonymizeUserService
implements AnonymizeUserService {
    private final UserManager userManager;

    public DefaultAnonymizeUserService(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public AnonymizeUserService.AnonymizeValidationResult validateAnonymize(AnonymizeUserService.AnonymizeUserRequest request) {
        SimpleErrorCollection error = new SimpleErrorCollection();
        ApplicationUser user = this.userManager.getUserByKey(request.getUser());
        if (user == null) {
            error.addErrorMessage("User doesn't exist.");
        } else {
            if (user.equals((Object)request.getExecutor())) {
                error.addErrorMessage("You can't anonymize yourself");
            }
            if (user.isActive()) {
                error.addErrorMessage("User has to be inactive.");
            }
        }
        return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)error, request);
    }

    @Override
    public ServiceResult perform(AnonymizeUserService.AnonymizeValidationResult validationResult) {
        Preconditions.checkArgument((boolean)validationResult.isValid());
        return new ServiceResultImpl((ErrorCollection)new SimpleErrorCollection());
    }
}

