/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleWarningCollection;
import com.atlassian.jira.util.WarningCollection;
import com.google.common.base.Preconditions;
import java.util.Optional;

@ExperimentalApi
public interface AnonymizeUserService {
    public AnonymizeValidationResult validateAnonymize(AnonymizeUserRequest var1);

    public ServiceResult perform(AnonymizeValidationResult var1);

    public static class AnonymizeValidationResult
    implements ServiceResult {
        private static final WarningCollection EMPTY_WARNING_COLLECTION = new SimpleWarningCollection();
        private final ErrorCollection errors;
        private final AnonymizeUserRequest request;

        public AnonymizeValidationResult(ErrorCollection errors, AnonymizeUserRequest request) {
            this.errors = errors;
            this.request = request;
        }

        public boolean isValid() {
            return !this.errors.hasAnyErrors();
        }

        public ErrorCollection getErrorCollection() {
            return this.errors;
        }

        public WarningCollection getWarningCollection() {
            return EMPTY_WARNING_COLLECTION;
        }

        public AnonymizeUserRequest getRequest() {
            return this.request;
        }
    }

    public static class AnonymizeUserRequest {
        private final String user;
        private final ApplicationUser newOwner;
        private final ApplicationUser executor;
        private final Context asyncTaskContext;

        private AnonymizeUserRequest(String user, ApplicationUser newOwner, ApplicationUser executor, Context asyncTaskContext) {
            this.user = (String)Preconditions.checkNotNull((Object)user);
            this.newOwner = (ApplicationUser)Preconditions.checkNotNull((Object)newOwner);
            this.executor = (ApplicationUser)Preconditions.checkNotNull((Object)executor);
            this.asyncTaskContext = (Context)Preconditions.checkNotNull((Object)asyncTaskContext);
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getUser() {
            return this.user;
        }

        public ApplicationUser getNewOwner() {
            return this.newOwner;
        }

        public ApplicationUser getExecutor() {
            return this.executor;
        }

        public Optional<Context> getAsyncTaskContext() {
            return Optional.ofNullable(this.asyncTaskContext);
        }

        public static class Builder {
            private String userKey;
            private ApplicationUser newOwner;
            private ApplicationUser executor;
            private Context asyncTaskContext = Contexts.nullContext();

            public Builder targetUser(String userKey) {
                this.userKey = userKey;
                return this;
            }

            public Builder newOwner(ApplicationUser newOwner) {
                this.newOwner = newOwner;
                return this;
            }

            public Builder executor(ApplicationUser executor) {
                this.executor = executor;
                return this;
            }

            public Builder asyncTaskContext(Context asyncTaskContext) {
                this.asyncTaskContext = asyncTaskContext;
                return this;
            }

            public AnonymizeUserRequest build() {
                return new AnonymizeUserRequest(this.userKey, this.newOwner, this.executor, this.asyncTaskContext);
            }
        }
    }
}

