/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.core.util.Clock;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.license.Jira6xServiceDeskPluginEncodedLicenseSupplier;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.RenaissanceMigrationStatus;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRolesDaoImpl;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDaoImpl;
import com.atlassian.jira.upgrade.tasks.role.Jira6xServiceDeskLicenseProviderImpl;
import com.atlassian.jira.upgrade.tasks.role.LicenseDaoImpl;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.upgrade.tasks.role.MigrationGroupServiceImpl;
import com.atlassian.jira.upgrade.tasks.role.MigrationLogDaoImpl;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationStateDao;
import com.atlassian.jira.upgrade.tasks.role.MigrationStateDaoImpl;
import com.atlassian.jira.upgrade.tasks.role.MigrationTask;
import com.atlassian.jira.upgrade.tasks.role.MigrationValidator;
import com.atlassian.jira.upgrade.tasks.role.MigrationValidatorImpl;
import com.atlassian.jira.upgrade.tasks.role.Move6xLicenseTo70Store;
import com.atlassian.jira.upgrade.tasks.role.Move6xServiceDeskLicenseTo70Store;
import com.atlassian.jira.upgrade.tasks.role.Move6xUsePermissionOverToCoreAndSoftwareApplications;
import com.atlassian.jira.upgrade.tasks.role.MoveJira6xABPServiceDeskPermissions;
import com.atlassian.jira.upgrade.tasks.role.MoveJira6xServiceDeskPermissions;
import com.atlassian.jira.upgrade.tasks.role.MoveJira6xTBPServiceDeskPermissions;
import com.atlassian.jira.upgrade.tasks.role.RenaissanceMigration;
import com.atlassian.jira.upgrade.tasks.role.ServiceDeskPropertySetDaoImpl;
import com.atlassian.jira.upgrade.tasks.role.UseBasedMigrationImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenaissanceMigrationImpl
implements RenaissanceMigration {
    private final MigrationStateDao migrationStateDao;
    private final List<MigrationTask> migrationTasks;
    private final ExternalLinkUtil externalLinkUtil;
    private final MigrationValidator migrationValidator;
    private final RenaissanceMigrationStatus migrationStatus;
    private final Logger log;
    private final Clock clock;

    @Inject
    public RenaissanceMigrationImpl(ApplicationProperties properties, JiraLicenseManager licenseManager, ApplicationRoleManager applicationRoleManager, ExternalLinkUtil externalLinkUtil, OfBizDelegator db, CrowdService crowdService, RenaissanceMigrationStatus migrationStatus, ApplicationProperties applicationProperties, Clock clock) {
        Assertions.notNull((String)"crowdService", (Object)crowdService);
        Assertions.notNull((String)"properties", (Object)properties);
        Assertions.notNull((String)"licenseManager", (Object)licenseManager);
        Assertions.notNull((String)"db", (Object)db);
        Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
        this.clock = (Clock)Assertions.notNull((String)"clock", (Object)clock);
        this.log = LoggerFactory.getLogger(MigrationValidatorImpl.class);
        GlobalPermissionDaoImpl globalPermissionDao = new GlobalPermissionDaoImpl(db);
        this.externalLinkUtil = (ExternalLinkUtil)Assertions.notNull((String)"externalLinkUtil", (Object)externalLinkUtil);
        this.migrationStatus = (RenaissanceMigrationStatus)Assertions.notNull((String)"migrationVersionStore", (Object)migrationStatus);
        LicenseDaoImpl licenseDao = new LicenseDaoImpl(properties, db, licenseManager);
        ApplicationRolesDaoImpl rolesDao = new ApplicationRolesDaoImpl(db, applicationRoleManager);
        UseBasedMigrationImpl useBasedMigration = new UseBasedMigrationImpl(globalPermissionDao);
        this.migrationStateDao = new MigrationStateDaoImpl(licenseDao, rolesDao, new MigrationLogDaoImpl(db));
        Jira6xServiceDeskPluginEncodedLicenseSupplier sdLicenseSupplier = new Jira6xServiceDeskPluginEncodedLicenseSupplier(properties);
        MigrationGroupServiceImpl migrationGroupService = new MigrationGroupServiceImpl(globalPermissionDao, crowdService);
        Jira6xServiceDeskLicenseProviderImpl jira6xServiceDeskLicenseProvider = new Jira6xServiceDeskLicenseProviderImpl(sdLicenseSupplier, licenseDao);
        this.migrationValidator = new MigrationValidatorImpl(globalPermissionDao, jira6xServiceDeskLicenseProvider, migrationGroupService);
        this.migrationTasks = ImmutableList.of((Object)new Move6xLicenseTo70Store(licenseDao), (Object)new Move6xServiceDeskLicenseTo70Store(sdLicenseSupplier), (Object)new Move6xUsePermissionOverToCoreAndSoftwareApplications(useBasedMigration), (Object)new MoveJira6xServiceDeskPermissions(jira6xServiceDeskLicenseProvider, new ServiceDeskPropertySetDaoImpl(db), new MoveJira6xTBPServiceDeskPermissions(useBasedMigration), new MoveJira6xABPServiceDeskPermissions(migrationGroupService, globalPermissionDao, applicationProperties)));
    }

    @VisibleForTesting
    RenaissanceMigrationImpl(MigrationStateDao migrationStateDao, ExternalLinkUtil externalLinkUtil, Iterable<? extends MigrationTask> migrationTasks, MigrationValidator migrationValidator, RenaissanceMigrationStatus migrationStatus, Clock clock, Logger logger) {
        this.migrationTasks = ImmutableList.copyOf((Iterable)((Iterable)Assertions.notNull((String)"migrationTasks", migrationTasks)));
        this.migrationStateDao = (MigrationStateDao)Assertions.notNull((String)"migrationStateDao", (Object)migrationStateDao);
        this.externalLinkUtil = (ExternalLinkUtil)Assertions.notNull((String)"externalLinkUtil", (Object)externalLinkUtil);
        this.migrationValidator = (MigrationValidator)Assertions.notNull((String)"migrationValidator", (Object)migrationValidator);
        this.migrationStatus = (RenaissanceMigrationStatus)Assertions.notNull((String)"migrationPredicate", (Object)migrationStatus);
        this.clock = (Clock)Assertions.notNull((String)"clock", (Object)clock);
        this.log = logger;
    }

    @Override
    public MigrationState executeTasksAndValidate() {
        Date taskEndTime;
        Date taskStartTime;
        MigrationState original = this.migrationStateDao.get();
        boolean suppliedByUser = !original.licenses().isEmpty();
        MigrationState migrationState = original;
        for (MigrationTask migrationMigrationTask : this.migrationTasks) {
            taskStartTime = this.clock.getCurrentDate();
            migrationState = migrationMigrationTask.migrate(migrationState, suppliedByUser);
            taskEndTime = this.clock.getCurrentDate();
            this.log.info("Elapsed time of " + (taskEndTime.getTime() - taskStartTime.getTime()) + "ms for migration task: " + migrationMigrationTask.getClass().getSimpleName());
        }
        taskStartTime = this.clock.getCurrentDate();
        this.migrationValidator.validate(original, migrationState);
        taskEndTime = this.clock.getCurrentDate();
        this.log.info("Elapsed time of " + (taskEndTime.getTime() - taskStartTime.getTime()) + "ms for migration validation task");
        return migrationState;
    }

    @Override
    public void migrate() {
        try {
            MigrationState migrationState = this.executeTasksAndValidate();
            this.migrationStateDao.put(migrationState);
            migrationState.afterSaveTasks().forEach(Runnable::run);
            this.migrationStatus.markDone();
        }
        catch (MigrationFailedException e) {
            String supportLink = this.externalLinkUtil.getProperty("external.link.jira.support.site");
            String msg = String.format("JIRA migration failed. Please contact Atlassian Support at %s.", supportLink);
            throw new MigrationFailedException(msg, e);
        }
    }
}

