/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.jira.upgrade.tasks.role.Jira6xServiceDeskLicenseProvider;
import com.atlassian.jira.upgrade.tasks.role.License;
import com.atlassian.jira.upgrade.tasks.role.LicenseUtils;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationTask;
import com.atlassian.jira.upgrade.tasks.role.MoveJira6xABPServiceDeskPermissions;
import com.atlassian.jira.upgrade.tasks.role.MoveJira6xTBPServiceDeskPermissions;
import com.atlassian.jira.upgrade.tasks.role.ServiceDeskPropertySetDao;
import io.atlassian.fugue.Option;

final class MoveJira6xServiceDeskPermissions
extends MigrationTask {
    private static final String PROPERTY_ABP_LICENSE = "ABP";
    private static final String PROPERTY_TBP_LICENSE = "TBP";
    private static final String PROPERTY_LICENSE_NONE = "none";
    private static final String PROPERTY_KEY_MIGRATION_LICENSE = "com.atlassian.servicedesk.renaissance.migration.type";
    private final Jira6xServiceDeskLicenseProvider jira6xServiceDeskLicenseProvider;
    private final ServiceDeskPropertySetDao serviceDeskPropertySetDao;
    private final MoveJira6xTBPServiceDeskPermissions moveJira6XTBPServiceDeskPermissions;
    private final MoveJira6xABPServiceDeskPermissions moveJira6xABPServiceDeskPermissions;

    MoveJira6xServiceDeskPermissions(Jira6xServiceDeskLicenseProvider jira6xServiceDeskLicenseProvider, ServiceDeskPropertySetDao serviceDeskPropertySetDao, MoveJira6xTBPServiceDeskPermissions moveJira6XTBPServiceDeskPermissions, MoveJira6xABPServiceDeskPermissions moveJira6xABPServiceDeskPermissions) {
        this.jira6xServiceDeskLicenseProvider = jira6xServiceDeskLicenseProvider;
        this.serviceDeskPropertySetDao = serviceDeskPropertySetDao;
        this.moveJira6XTBPServiceDeskPermissions = moveJira6XTBPServiceDeskPermissions;
        this.moveJira6xABPServiceDeskPermissions = moveJira6xABPServiceDeskPermissions;
    }

    @Override
    MigrationState migrate(MigrationState state, boolean licenseSuppliedByUser) {
        Option<License> license = this.jira6xServiceDeskLicenseProvider.serviceDeskLicense();
        if (license.isEmpty()) {
            return state.withAfterSaveTask(() -> this.setSdMigrationProperty(PROPERTY_LICENSE_NONE));
        }
        LicenseUtils.ServiceDeskLicenseType licenseType = LicenseUtils.determineServiceDeskLicenseType((License)license.get());
        switch (licenseType) {
            case TierBasedPricing: {
                return this.moveJira6XTBPServiceDeskPermissions.migrate(state, licenseSuppliedByUser).withAfterSaveTask(() -> this.setSdMigrationProperty(PROPERTY_TBP_LICENSE));
            }
            case AgentBasedPricing: {
                return this.moveJira6xABPServiceDeskPermissions.migrate(state, licenseSuppliedByUser).withAfterSaveTask(() -> this.setSdMigrationProperty(PROPERTY_ABP_LICENSE));
            }
        }
        throw new MigrationFailedException("Unsupported service desk license type: " + (Object)((Object)licenseType));
    }

    private void setSdMigrationProperty(String migrationType) {
        this.serviceDeskPropertySetDao.writeStringProperty(PROPERTY_KEY_MIGRATION_LICENSE, migrationType);
    }
}

