/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.CachingComponent;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.ChangedValueImpl;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.tasks.role.AuditEntry;
import com.atlassian.jira.upgrade.tasks.role.AuditEntrySeverity;
import com.atlassian.jira.upgrade.tasks.role.DefaultApplicationDao;
import com.atlassian.jira.upgrade.tasks.role.DefaultApplicationDaoImpl;
import com.atlassian.jira.upgrade.tasks.role.DefaultApplicationService;
import com.atlassian.jira.upgrade.tasks.role.License;
import com.atlassian.jira.upgrade.tasks.role.LicenseDao;
import com.atlassian.jira.upgrade.tasks.role.LicenseDaoImpl;
import com.atlassian.jira.upgrade.tasks.role.Licenses;
import com.atlassian.jira.upgrade.tasks.role.MigrationLogDao;
import com.atlassian.jira.upgrade.tasks.role.MigrationLogDaoImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationServiceImpl
implements DefaultApplicationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultApplicationServiceImpl.class);
    private static final boolean EVENT_SHOWS_IN_CLOUD_LOG = true;
    private final MigrationLogDao migrationLogDao;
    private final LicenseDao licenseDao;
    private final DefaultApplicationDao defaultApplicationDao;
    private final ApplicationRoleManager applicationRoleManager;
    private final OfBizDelegator db;
    private final ApplicationProperties applicationProperties;
    private final JiraLicenseManager jiraLicenseManager;

    public DefaultApplicationServiceImpl(ApplicationRoleManager applicationRoleManager, OfBizDelegator db, ApplicationProperties applicationProperties, JiraLicenseManager jiraLicenseManager) {
        this.applicationRoleManager = applicationRoleManager;
        this.db = db;
        this.applicationProperties = applicationProperties;
        this.jiraLicenseManager = jiraLicenseManager;
        this.migrationLogDao = new MigrationLogDaoImpl(db);
        this.licenseDao = new LicenseDaoImpl(this.applicationProperties, this.db, this.jiraLicenseManager);
        this.defaultApplicationDao = new DefaultApplicationDaoImpl(db);
    }

    @VisibleForTesting
    DefaultApplicationServiceImpl(MigrationLogDao migrationLogDao, LicenseDao licenseDao, DefaultApplicationDao defaultApplicationDao, ApplicationRoleManager applicationRoleManager) {
        this.migrationLogDao = (MigrationLogDao)Assertions.notNull((String)"migrationLogDao", (Object)migrationLogDao);
        this.licenseDao = (LicenseDao)Assertions.notNull((String)"licenseDao", (Object)licenseDao);
        this.defaultApplicationDao = (DefaultApplicationDao)Assertions.notNull((String)"defaultApplicationDao", (Object)defaultApplicationDao);
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
        this.db = null;
        this.applicationProperties = null;
        this.jiraLicenseManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationsAsDefaultDuring6xTo7xUpgrade() {
        Licenses licenses = this.licenseDao.getLicenses();
        Set<ApplicationKey> licensedApps = this.getLicensedApplications(licenses);
        Option<ApplicationKey> licensedAppOption = this.getAppToSetAsDefault(licensedApps);
        if (licensedAppOption.isEmpty()) {
            log.info("Found no licenses. Default applications will not be selected.");
            return;
        }
        try {
            ApplicationKey applicationKey = (ApplicationKey)licensedAppOption.get();
            this.createAuditingRecord(applicationKey);
            this.defaultApplicationDao.setApplicationsAsDefault(Collections.singleton(applicationKey));
        }
        finally {
            if (this.applicationRoleManager instanceof CachingComponent) {
                log.info("Clearing caches for application roles.");
                ((CachingComponent)this.applicationRoleManager).clearCache();
            }
        }
    }

    private void createAuditingRecord(ApplicationKey applicationKey) {
        log.debug("Creating audit entry for {}. The application will be marked as a default.", (Object)applicationKey);
        ImmutableList changedValues = ImmutableList.of((Object)new ChangedValueImpl(applicationKey.toString(), "", applicationKey + " (default)"));
        this.migrationLogDao.store(new AuditEntry(this.getClass(), "Setting the application defaults", "Applications were marked as default, based on the product license. New users will be created with respect to the default applications selection.", AssociatedItem.Type.APPLICATION_ROLE, applicationKey.toString(), true, (Iterable<ChangedValue>)changedValues, AuditEntrySeverity.INFO));
    }

    private Option<ApplicationKey> getAppToSetAsDefault(Set<ApplicationKey> licensedApps) {
        if (licensedApps.contains(ApplicationKeys.SOFTWARE)) {
            return Option.option((Object)ApplicationKeys.SOFTWARE);
        }
        if (licensedApps.contains(ApplicationKeys.CORE)) {
            return Option.option((Object)ApplicationKeys.CORE);
        }
        return Option.none();
    }

    @VisibleForTesting
    Set<ApplicationKey> getLicensedApplications(Licenses licenses) {
        return licenses.get().stream().map(License::applicationKeys).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

