/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.model.querydsl.QOSCurrentStep;
import com.atlassian.jira.model.querydsl.QOSHistoryStep;
import com.atlassian.jira.model.querydsl.QOSHistoryStepPrev;
import com.atlassian.jira.model.querydsl.QOSWorkflowEntry;
import com.atlassian.jira.model.querydsl.QProject;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build73011
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build73011.class);
    private static final long MIN_ID_INITIAL = -1L;
    private static final long BATCH_SIZE = 500L;
    private static final long FAILED_ISSUES_REPORT_LIMIT = 1000L;
    private final QueryDslAccessor dbConnectionManager;
    private final DelegatorInterface delegator;

    public UpgradeTask_Build73011(QueryDslAccessor dbConnectionManager, DelegatorInterface delegator) {
        this.dbConnectionManager = dbConnectionManager;
        this.delegator = delegator;
    }

    public int getBuildNumber() {
        return 73011;
    }

    public String getShortDescription() {
        return "Make all issues active in workflow";
    }

    private DelegatorInterface getDelegator() {
        return this.delegator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUpgrade(UpgradeContext upgradeContext) {
        if (upgradeContext.getTrigger() == UpgradeContext.UpgradeTrigger.PROVISIONING) {
            log.debug("Skipping upgrade task");
            return;
        }
        log.debug("Starting upgrade task, limit: {}", (Object)500L);
        Stopwatch stopwatchBatch = Stopwatch.createUnstarted();
        Stopwatch overallStopwatch = Stopwatch.createStarted();
        IndexWorker indexWorker = new IndexWorker();
        this.dropPreviouslyCreatedIndexIfAny(indexWorker);
        try {
            indexWorker.createIndex();
            List<Long> workflowIds = this.getWorkflowIdsForClosedIssues(-1L, 500L);
            while (!workflowIds.isEmpty()) {
                stopwatchBatch.reset().start();
                this.restoreEntriesFromHistory(workflowIds);
                this.deleteRestoredEntriesFromHistory(workflowIds);
                this.deleteRestoredEntriesFromHistoryPrev(workflowIds);
                this.activateRestoredEntries(workflowIds);
                Long minId = workflowIds.get(workflowIds.size() - 1);
                workflowIds = this.getWorkflowIdsForClosedIssues(minId, 500L);
                log.debug("Processing batch took {}", (Object)stopwatchBatch);
            }
            this.logIssuesNotFixed();
        }
        finally {
            indexWorker.dropIndex();
        }
        log.debug("[DONE] Upgrade task done in {}", (Object)overallStopwatch);
    }

    private void dropPreviouslyCreatedIndexIfAny(IndexWorker indexWorker) {
        try {
            log.debug("Dropping previously created index");
            indexWorker.dropIndex();
        }
        catch (Exception e) {
            log.debug("Dropping previously created index", (Throwable)e);
        }
    }

    private void activateRestoredEntries(List<Long> workflowIdsFinal) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("Updating OS_WORKFLOW_ENTRY");
        long updated = this.dbConnectionManager.executeQuery(dbConnection -> dbConnection.update((RelationalPath<?>)QOSWorkflowEntry.O_S_WORKFLOW_ENTRY).set(QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.state, (Object)1).where((Predicate)QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(QOSCurrentStep.O_S_CURRENT_STEP.entryId).from((Expression)QOSCurrentStep.O_S_CURRENT_STEP)).where((Predicate)QOSCurrentStep.O_S_CURRENT_STEP.entryId.in((Collection)workflowIdsFinal)))).execute());
        log.debug("[DONE] Updating OS_WORKFLOW_ENTRY, {}, took {}", (Object)updated, (Object)stopwatch);
    }

    private void deleteRestoredEntriesFromHistoryPrev(List<Long> workflowIdsFinal) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("Delete from OS_HISTORYSTEP_PREV");
        long deleted = this.dbConnectionManager.executeQuery(dbConnection -> dbConnection.delete((RelationalPath<?>)QOSHistoryStepPrev.O_S_HISTORY_STEP_PREV).where((Predicate)QOSHistoryStepPrev.O_S_HISTORY_STEP_PREV.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(QOSCurrentStep.O_S_CURRENT_STEP.id).from((Expression)QOSCurrentStep.O_S_CURRENT_STEP)).where((Predicate)QOSCurrentStep.O_S_CURRENT_STEP.entryId.in((Collection)workflowIdsFinal)))).execute());
        log.debug("[DONE] Delete from OS_HISTORYSTEP_PREV, {}, took {}", (Object)deleted, (Object)stopwatch);
    }

    private void deleteRestoredEntriesFromHistory(List<Long> workflowIdsFinal) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("Delete from OS_HISTORYSTEP");
        long deleted = this.dbConnectionManager.executeQuery(dbConnection -> dbConnection.delete((RelationalPath<?>)QOSHistoryStep.O_S_HISTORY_STEP).where((Predicate)QOSHistoryStep.O_S_HISTORY_STEP.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(QOSCurrentStep.O_S_CURRENT_STEP.id).from((Expression)QOSCurrentStep.O_S_CURRENT_STEP)).where((Predicate)QOSCurrentStep.O_S_CURRENT_STEP.entryId.in((Collection)workflowIdsFinal)))).execute());
        log.debug("[DONE] Delete from OS_HISTORYSTEP done, {}, took {}", (Object)deleted, (Object)stopwatch);
    }

    private void restoreEntriesFromHistory(List<Long> workflowIdsFinal) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("Inserting OS_CURRENTSTEP. No of processed entries: {}", (Object)workflowIdsFinal.size());
        QOSHistoryStep historyStep = new QOSHistoryStep("hs");
        QOSHistoryStep hs2 = new QOSHistoryStep("hs2");
        QOSHistoryStepPrev prevStep = new QOSHistoryStepPrev("prevStep");
        Path[] currentStepColumns = new Path[]{QOSCurrentStep.O_S_CURRENT_STEP.id, QOSCurrentStep.O_S_CURRENT_STEP.entryId, QOSCurrentStep.O_S_CURRENT_STEP.stepId, QOSCurrentStep.O_S_CURRENT_STEP.actionId, QOSCurrentStep.O_S_CURRENT_STEP.owner, QOSCurrentStep.O_S_CURRENT_STEP.startDate, QOSCurrentStep.O_S_CURRENT_STEP.dueDate, QOSCurrentStep.O_S_CURRENT_STEP.finishDate, QOSCurrentStep.O_S_CURRENT_STEP.status, QOSCurrentStep.O_S_CURRENT_STEP.caller};
        Expression[] historyStepColumns = new Expression[]{historyStep.id, historyStep.entryId, historyStep.stepId, historyStep.actionId, historyStep.owner, historyStep.startDate, historyStep.dueDate, Expressions.nullExpression(), historyStep.status, historyStep.caller};
        Preconditions.checkState((currentStepColumns.length == historyStepColumns.length ? 1 : 0) != 0);
        long inserted = this.dbConnectionManager.executeQuery(dbConnection -> dbConnection.insert(QOSCurrentStep.O_S_CURRENT_STEP).columns(currentStepColumns).select((SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression[])historyStepColumns).from((Expression)historyStep)).where((Predicate)historyStep.entryId.in((Collection)workflowIdsFinal).and((Predicate)((SQLQuery)((SQLQuery)SQLExpressions.select(QIssue.ISSUE.id).from((Expression)QIssue.ISSUE)).where((Predicate)QIssue.ISSUE.workflowId.eq(historyStep.entryId).and((Predicate)((SQLQuery)((SQLQuery)SQLExpressions.select(QOSCurrentStep.O_S_CURRENT_STEP.id).from((Expression)QOSCurrentStep.O_S_CURRENT_STEP)).where((Predicate)QOSCurrentStep.O_S_CURRENT_STEP.entryId.eq(QIssue.ISSUE.workflowId))).notExists()))).exists()).and((Predicate)historyStep.id.eq((Expression)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(hs2.id).from((Expression)hs2)).where((Predicate)historyStep.entryId.eq(hs2.entryId).and((Predicate)hs2.finishDate.isNotNull()).and((Predicate)((SQLQuery)((SQLQuery)SQLExpressions.select(prevStep.id).from((Expression)prevStep)).where((Predicate)prevStep.previousId.eq(hs2.id))).notExists()))).orderBy(hs2.finishDate.desc())).limit(1L))).and((Predicate)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression)hs2.finishDate.count()).from((Expression)hs2)).where((Predicate)historyStep.entryId.eq(hs2.entryId).and((Predicate)hs2.finishDate.isNotNull()).and((Predicate)((SQLQuery)((SQLQuery)SQLExpressions.select(prevStep.id).from((Expression)prevStep)).where((Predicate)prevStep.previousId.eq(hs2.id))).notExists()))).groupBy(hs2.finishDate)).orderBy(hs2.finishDate.desc())).limit(1L)).eq((Object)1L)))).execute());
        log.debug("[DONE] Inserted OS_CURRENTSTEP. Inserted size: {}, took: {}", (Object)inserted, (Object)stopwatch);
    }

    private void logIssuesNotFixed() {
        List<Tuple> notFixed = this.getInvalidEntries(1000L);
        if (notFixed.size() > 0) {
            log.error("Not fixed issues (limit to {}), [issueId, projectId, workflowId, projectKey, issueNumber]: {}, {}", new Object[]{1000L, notFixed.size(), notFixed});
        } else {
            log.debug("All issues fixed");
        }
    }

    private List<Long> getWorkflowIdsForClosedIssues(Long minId, Long limit) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("Fetching workflowIds, limit: {}, minId: {}", (Object)limit, (Object)minId);
        QueryCallback<List> callback = dbConnection -> {
            SQLQuery workflowIdsForClosedIssuesQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(QIssue.ISSUE.workflowId).from((Expression)QIssue.ISSUE)).leftJoin((EntityPath)QOSCurrentStep.O_S_CURRENT_STEP)).on((Predicate)QOSCurrentStep.O_S_CURRENT_STEP.entryId.eq(QIssue.ISSUE.workflowId))).where((Predicate)QOSCurrentStep.O_S_CURRENT_STEP.id.isNull().and((Predicate)QIssue.ISSUE.workflowId.gt((Number)minId)))).orderBy(QIssue.ISSUE.workflowId.asc());
            if (Objects.nonNull(limit)) {
                workflowIdsForClosedIssuesQuery.limit(limit.longValue());
            }
            return workflowIdsForClosedIssuesQuery.fetch();
        };
        List workflowIdsForClosedIssues = this.dbConnectionManager.executeQuery(callback);
        log.debug("Fetched workflowIds, size: {}, ids: {}, took: {}", new Object[]{workflowIdsForClosedIssues.size(), workflowIdsForClosedIssues, stopwatch});
        return workflowIdsForClosedIssues;
    }

    private List<Tuple> getInvalidEntries(Long limit) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        QIssue issue = new QIssue("i");
        QOSCurrentStep cs = new QOSCurrentStep("cs");
        QProject proj = new QProject("p");
        log.debug("Fetching invalid entries, limit: {}", (Object)limit);
        List invalidEntries = this.dbConnectionManager.executeQuery(dbConnection -> {
            SQLQuery invalidEntriesQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(new Expression[]{issue.id, issue.project, issue.workflowId, proj.key, issue.number}).from((Expression)issue)).leftJoin((EntityPath)cs)).on((Predicate)cs.entryId.eq(issue.workflowId))).leftJoin((EntityPath)proj)).on((Predicate)issue.project.eq(proj.id))).where((Predicate)cs.id.isNull())).orderBy(issue.id.asc());
            if (Objects.nonNull(limit)) {
                invalidEntriesQuery.limit(limit.longValue());
            }
            return invalidEntriesQuery.fetch();
        });
        log.debug("Fetched invalid entries, size: {}, took: {}", (Object)invalidEntries.size(), (Object)stopwatch);
        return invalidEntries;
    }

    private class IndexWorker {
        final DatabaseUtil dbUtil;
        final ModelEntity historyStepPrev;
        final ModelIndex historystepPrevIdx;

        private IndexWorker() {
            try {
                GenericHelper helper = UpgradeTask_Build73011.this.getDelegator().getEntityHelper("OSHistoryStepPrev");
                this.dbUtil = new DatabaseUtil(helper.getHelperName());
                this.historyStepPrev = UpgradeTask_Build73011.this.getDelegator().getModelEntity("OSHistoryStepPrev");
                this.historystepPrevIdx = new ModelIndex();
                this.historystepPrevIdx.setName("os_hsp_prev_id_idx161125");
                this.historystepPrevIdx.setMainEntity(this.historyStepPrev);
                this.historystepPrevIdx.setUnique(false);
                this.historystepPrevIdx.addIndexField("previousId");
            }
            catch (GenericEntityException e) {
                throw new RuntimeException("Failed to create IndexWorker", e);
            }
        }

        private void createIndex() {
            Stopwatch stopwatch = Stopwatch.createStarted();
            log.debug("Index creation start");
            String error = this.dbUtil.createDeclaredIndex(this.historyStepPrev, this.historystepPrevIdx);
            if (error != null) {
                throw new RuntimeException("Could not create index: " + error);
            }
            log.debug("Index creation took: {}", (Object)stopwatch);
        }

        private void dropIndex() {
            Stopwatch stopwatch = Stopwatch.createStarted();
            log.debug("Index drop start");
            String error = this.dbUtil.deleteDeclaredIndex(this.historyStepPrev, this.historystepPrevIdx);
            if (error != null) {
                throw new RuntimeException("Could not drop index: " + error);
            }
            log.debug("Index drop took: {}", (Object)stopwatch);
        }
    }
}

