/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationPropertiesImpl;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizDirectoryDao;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigPersisterImpl;
import com.atlassian.jira.model.querydsl.QDirectory;
import com.atlassian.jira.model.querydsl.QFieldConfiguration;
import com.atlassian.jira.model.querydsl.QGadgetUserPreference;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyString;
import com.atlassian.jira.portal.CachingPortletConfigurationStore;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.Optional;

public class UpgradeTask_Build711001
implements UpgradeTask {
    private QueryDslAccessor queryDslAccessor;
    private static Multimap<String, String> OLD_DEFAULT_PROPERTIES = ImmutableMultimap.of((Object)"jira.email.fromheader.format", (Object)"${fullname} (JIRA)", (Object)"jira.title", (Object)"JIRA", (Object)"jira.title", (Object)"Your Company JIRA");

    public UpgradeTask_Build711001(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    public int getBuildNumber() {
        return 711001;
    }

    public String getShortDescription() {
        return "Update default values stored in DB with new Jira branding";
    }

    public void runUpgrade(UpgradeContext upgradeContext) {
        this.updateApplicationProperties();
        this.updateUserDirectories();
        this.updateFieldConfigurations();
        this.updateGadgets();
    }

    private void updateApplicationProperties() {
        OLD_DEFAULT_PROPERTIES.keySet().stream().filter(this::isDefault).forEach(this::decapitalize);
        ComponentAccessor.getComponentSafely(ApplicationPropertiesImpl.class).ifPresent(ApplicationPropertiesImpl::refresh);
    }

    private boolean isDefault(String propertyKey) {
        return this.getStringProperty(propertyKey).map(actualValue -> OLD_DEFAULT_PROPERTIES.get((Object)propertyKey).contains(actualValue)).orElse(false);
    }

    private Optional<String> getStringProperty(String key) {
        return Optional.ofNullable(this.queryDslAccessor.executeQuery(connection -> (String)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)QOSPropertyString.O_S_PROPERTY_STRING.value).from((Expression)QOSPropertyString.O_S_PROPERTY_STRING)).join((EntityPath)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).on((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(QOSPropertyString.O_S_PROPERTY_STRING.id))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)key))).fetchFirst()));
    }

    private void decapitalize(String propertyKey) {
        Optional<String> current = this.getStringProperty(propertyKey);
        if (current.isPresent()) {
            this.queryDslAccessor.execute(connection -> connection.update((RelationalPath<?>)QOSPropertyString.O_S_PROPERTY_STRING).set((Path)QOSPropertyString.O_S_PROPERTY_STRING.value, (Object)((String)current.get()).replace("JIRA", "Jira")).where((Predicate)QOSPropertyString.O_S_PROPERTY_STRING.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)propertyKey)))).execute());
        }
    }

    private void updateUserDirectories() {
        String oldDescription = "JIRA default internal directory";
        String replacementDescription = "Jira default internal directory";
        String oldName = "JIRA Internal Directory";
        String replacementName = "Jira Internal Directory";
        this.queryDslAccessor.execute(connection -> {
            connection.update((RelationalPath<?>)QDirectory.DIRECTORY).set((Path)QDirectory.DIRECTORY.description, (Object)"Jira default internal directory").where((Predicate)QDirectory.DIRECTORY.description.eq((Object)"JIRA default internal directory")).execute();
            connection.update((RelationalPath<?>)QDirectory.DIRECTORY).set((Path)QDirectory.DIRECTORY.directoryName, (Object)"Jira Internal Directory").where((Predicate)QDirectory.DIRECTORY.directoryName.eq((Object)"JIRA Internal Directory")).execute();
        });
        ComponentAccessor.getComponentSafely(OfBizDirectoryDao.class).ifPresent(OfBizDirectoryDao::flushCache);
    }

    private void updateFieldConfigurations() {
        String oldDescription = "Default configuration generated by JIRA";
        String replacement = "Default configuration generated by Jira";
        this.queryDslAccessor.execute(connection -> connection.update((RelationalPath<?>)QFieldConfiguration.FIELD_CONFIGURATION).set((Path)QFieldConfiguration.FIELD_CONFIGURATION.description, (Object)replacement).where((Predicate)QFieldConfiguration.FIELD_CONFIGURATION.description.like(oldDescription)).execute());
        ComponentAccessor.getComponentSafely(FieldConfigPersisterImpl.class).ifPresent(fieldConfigPersister -> fieldConfigPersister.onClearCache(null));
    }

    private void updateGadgets() {
        long gadgetPreferenceId = 10003L;
        String oldTitle = "Your Company JIRA";
        String replacement = "Your Company Jira";
        this.queryDslAccessor.execute(connection -> connection.update((RelationalPath<?>)QGadgetUserPreference.GADGET_USER_PREFERENCE).set((Path)QGadgetUserPreference.GADGET_USER_PREFERENCE.userprefvalue, (Object)"Your Company Jira").where((Predicate)QGadgetUserPreference.GADGET_USER_PREFERENCE.id.eq((Object)10003L).and((Predicate)QGadgetUserPreference.GADGET_USER_PREFERENCE.userprefvalue.like("Your Company JIRA"))).execute());
        ComponentAccessor.getComponentSafely(CachingPortletConfigurationStore.class).ifPresent(CachingPortletConfigurationStore::flush);
    }
}

