/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.index.request.ReindexRequestTypes;
import com.atlassian.jira.upgrade.UpgradeIndexManager;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.core.UpgradeTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUpgradeManager {
    private static final Logger log = LoggerFactory.getLogger(PluginUpgradeManager.class);
    private static final String lockName = PluginUpgradeManager.class.getName();
    private final UpgradeTaskManager upgradeTaskManager;
    private final UpgradeIndexManager upgradeIndexManager;
    private final ApplicationProperties applicationProperties;
    private final ClusterLockService clusterLockService;

    public PluginUpgradeManager(UpgradeTaskManager upgradeTaskManager, UpgradeIndexManager upgradeIndexManager, ApplicationProperties applicationProperties, ClusterLockService clusterLockService) {
        this.upgradeTaskManager = upgradeTaskManager;
        this.upgradeIndexManager = upgradeIndexManager;
        this.applicationProperties = applicationProperties;
        this.clusterLockService = clusterLockService;
    }

    public void upgradePlugin(String pluginKey) {
        ClusterLock lock = this.clusterLockService.getLockForName(lockName);
        lock.lock();
        try {
            log.debug("Upgrading " + pluginKey);
            this.upgradeTaskManager.upgradePlugin(this::getUpgradeTrigger, pluginKey);
            this.upgradeIndexManager.runReindexIfNeededAndAllowed(ReindexRequestTypes.noneAllowed());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upgradePlugins(UpgradeContext upgradeContext) {
        ClusterLock lock = this.clusterLockService.getLockForName(lockName);
        lock.lock();
        try {
            log.debug("Upgrading plugins");
            boolean bl = this.upgradeTaskManager.upgradePlugins(upgradeContext);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private UpgradeContext.UpgradeTrigger getUpgradeTrigger() {
        if (this.isJiraSetup()) {
            return UpgradeContext.UpgradeTrigger.UPGRADE;
        }
        return UpgradeContext.UpgradeTrigger.PROVISIONING;
    }

    private boolean isJiraSetup() {
        return "true".equals(this.applicationProperties.getString("jira.setup"));
    }
}

