/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.cluster.zdu.DatabaseUpgradeStateManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.instance.InstanceState;
import com.atlassian.jira.instance.InstanceStateProvider;
import com.atlassian.jira.upgrade.PluginUpgradeManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.upgrade.core.UpgradeTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUpgradeListener
implements InitializingComponent {
    private static final Logger log = LoggerFactory.getLogger(PluginUpgradeListener.class);
    private final UpgradeTaskManager upgradeTaskManager;
    private final PluginEventManager pluginEventManager;
    private final ApplicationProperties applicationProperties;
    private final DatabaseUpgradeStateManager databaseUpgradeStateManager;
    private final InstanceStateProvider instanceStateProvider;
    private final PluginUpgradeManager pluginUpgradeManager;

    public PluginUpgradeListener(UpgradeTaskManager upgradeTaskManager, PluginEventManager pluginEventManager, ApplicationProperties applicationProperties, DatabaseUpgradeStateManager databaseUpgradeStateManager, InstanceStateProvider instanceStateProvider, PluginUpgradeManager pluginUpgradeManager) {
        this.upgradeTaskManager = upgradeTaskManager;
        this.pluginEventManager = pluginEventManager;
        this.applicationProperties = applicationProperties;
        this.databaseUpgradeStateManager = databaseUpgradeStateManager;
        this.instanceStateProvider = instanceStateProvider;
        this.pluginUpgradeManager = pluginUpgradeManager;
    }

    @EventListener
    public void onPluginInstall(PluginEnabledEvent event) {
        Plugin plugin = event.getPlugin();
        String pluginKey = plugin.getKey();
        if (this.applicationProperties.getOption("jira.upgrade.force.manual.schedule")) {
            log.debug("Plugin upgrade not scheduled, {}=true", (Object)"jira.upgrade.force.manual.schedule");
            return;
        }
        if (!this.upgradeTaskManager.needsUpgrading(pluginKey)) {
            log.debug("No need to upgrade plugin {}.", (Object)pluginKey);
            return;
        }
        if (this.instanceStateProvider.currentState() == InstanceState.UPGRADE_REQUIRED) {
            log.debug("JIRA not upgraded yet, ignoring plugin {} upgrades.", (Object)pluginKey);
            return;
        }
        if (this.databaseUpgradeStateManager.areDelayedUpgradesHandledByCluster()) {
            log.debug("Plugin {} not upgraded, waiting for ZDU to handle plugin upgrades.", (Object)pluginKey);
            return;
        }
        this.pluginUpgradeManager.upgradePlugin(pluginKey);
    }

    @Override
    public void afterInstantiation() throws Exception {
        this.pluginEventManager.register((Object)this);
    }
}

