/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.transition;

import com.atlassian.jira.transition.TransitionEntry;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class DefaultTransitionEntry
implements TransitionEntry {
    private final int transitionId;
    private final Long fromStatusId;
    private final Long toStatusId;
    private final String name;
    private final boolean hasScreen;
    private final boolean hasConditions;
    private final boolean hasValidators;
    private final boolean isInitial;
    private final boolean isGlobal;

    public DefaultTransitionEntry(int transitionId, @Nullable Long fromStatusId, @NotNull Long toStatusId, @NotNull String name, boolean hasScreen, boolean hasConditions, boolean hasValidators, boolean isInitial, boolean isGlobal) {
        this.transitionId = transitionId;
        this.fromStatusId = fromStatusId;
        this.toStatusId = (Long)Assertions.notNull((Object)toStatusId);
        this.name = (String)Assertions.notNull((Object)name);
        this.hasScreen = hasScreen;
        this.hasConditions = hasConditions;
        this.hasValidators = hasValidators;
        this.isInitial = isInitial;
        this.isGlobal = isGlobal;
    }

    public int getTransitionId() {
        return this.transitionId;
    }

    public Long getFromStatusId() {
        return this.fromStatusId;
    }

    public Long getToStatusId() {
        return this.toStatusId;
    }

    public String getName() {
        return this.name;
    }

    public boolean getHasScreen() {
        return this.hasScreen;
    }

    public boolean getHasConditions() {
        return this.hasConditions;
    }

    public boolean getHasValidators() {
        return this.hasValidators;
    }

    public boolean getIsGlobal() {
        return this.isGlobal;
    }

    public boolean getIsInitial() {
        return this.isInitial;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TransitionEntry that = (TransitionEntry)o;
            return Objects.equals(this.transitionId, that.getTransitionId()) && Objects.equals(this.fromStatusId, that.getFromStatusId()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.toStatusId, that.getToStatusId()) && Objects.equals(this.hasScreen, that.getHasScreen()) && Objects.equals(this.hasConditions, that.getHasConditions()) && Objects.equals(this.hasValidators, that.getHasValidators()) && Objects.equals(this.isGlobal, that.getIsGlobal()) && Objects.equals(this.isInitial, that.getIsInitial());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.transitionId, this.fromStatusId, this.name, this.toStatusId, this.hasScreen, this.hasConditions, this.hasValidators, this.isGlobal, this.isInitial);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("transitionId", this.transitionId).add("name", (Object)this.name).add("fromStatusId", (Object)this.fromStatusId).add("toStatusId", (Object)this.toStatusId).add("hasScreen", this.hasScreen).add("hasConditions", this.hasConditions).add("hasValidators", this.hasValidators).add("isGlobal", this.isGlobal).add("isInitial", this.isInitial).toString();
    }
}

