/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template.velocity;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.template.velocity.VelocityEngineFactory;
import java.util.Properties;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVelocityEngineFactory
implements VelocityEngineFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultVelocityEngineFactory.class);
    private final String propertiesFileName;

    public DefaultVelocityEngineFactory(String propertiesFileName) {
        this.propertiesFileName = propertiesFileName;
    }

    public DefaultVelocityEngineFactory() {
        this.propertiesFileName = "velocity.properties";
    }

    @Override
    public VelocityEngine getEngine() {
        VelocityEngine velocityEngine = new VelocityEngine();
        this.initialiseVelocityEngine(velocityEngine);
        return velocityEngine;
    }

    private void initialiseVelocityEngine(VelocityEngine velocityEngine) {
        try {
            Properties velocityPropertiesFile = new Properties();
            try {
                velocityPropertiesFile.load(ClassLoaderUtils.getResourceAsStream((String)this.propertiesFileName, this.getClass()));
            }
            catch (Exception e) {
                log.warn("Could not configure the Velocity Engine from the velocity.properties, manually configuring.");
                velocityPropertiesFile.put("resource.loader", "class");
                velocityPropertiesFile.put("class.resource.loader.description", "Velocity Classpath Resource Loader");
                velocityPropertiesFile.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            }
            DefaultVelocityEngineFactory.enableDevMode(velocityPropertiesFile);
            velocityEngine.init(velocityPropertiesFile);
        }
        catch (Exception e) {
            log.error("Exception initialising Velocity: " + e, (Throwable)e);
        }
    }

    public static void enableDevMode(Properties velocityPropertiesFile) {
        if (JiraSystemProperties.getInstance().isDevMode()) {
            velocityPropertiesFile.put("class.resource.loader.cache", "false");
            velocityPropertiesFile.put("velocimacro.library.autoreload", "true");
            velocityPropertiesFile.put("plugin.resource.loader.cache", "false");
        }
    }
}

