/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.template.Template;
import com.atlassian.jira.template.TemplateManager;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultTemplateManager
implements TemplateManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultTemplateManager.class);
    private final ApplicationProperties applicationProperties;
    private final EventTypeManager eventTypeManager;
    private static final String templateIDMappingConfigFile = "email-template-id-mappings.xml";
    private static final String EMAIL_TEMPLATES = "templates/email/";
    @ClusterSafe(value="Program artifacts only.")
    private ResettableLazyReference<Holder> holderRef = new ResettableLazyReference<Holder>(){

        protected Holder create() throws Exception {
            return DefaultTemplateManager.this.initTemplates();
        }
    };

    public DefaultTemplateManager(ApplicationProperties applicationProperties, EventTypeManager eventTypeManager) {
        this.applicationProperties = applicationProperties;
        this.eventTypeManager = eventTypeManager;
    }

    @Override
    public Template getTemplate(Long templateId) {
        return (Template)((Holder)this.holderRef.get()).templatesMap.get((Object)templateId);
    }

    @Override
    public Template getTemplate(SchemeEntity notificationSchemeEntity) {
        Template template;
        Long templateId = (Long)notificationSchemeEntity.getTemplateId();
        if (templateId == null) {
            Long eventTypeId = (Long)notificationSchemeEntity.getEntityTypeId();
            EventType eventType = this.eventTypeManager.getEventType(eventTypeId);
            if (eventTypeId == null || eventType == null) {
                log.error("Unable to determine the email template for the notification scheme entity : " + notificationSchemeEntity.getId() + ".");
                throw new DataAccessException("Unable to determine the email template for the notification scheme entity : " + notificationSchemeEntity.getId() + ".");
            }
            template = this.getDefaultTemplate(eventType);
        } else {
            template = this.getTemplate(templateId);
        }
        return template;
    }

    public Template getDefaultTemplate(EventType eventType) {
        return this.getTemplate(eventType.getTemplateId());
    }

    @Override
    public Map<Long, Template> getTemplatesMap(final String type) {
        if (type == null) {
            return ImmutableMap.of();
        }
        return Maps.filterValues(this.getAllTemplatesMap(), (Predicate)new Predicate<Template>(){

            public boolean apply(Template input) {
                return input.getType().equals(type);
            }
        });
    }

    private Map<Long, Template> getAllTemplatesMap() {
        return ((Holder)this.holderRef.get()).templatesMap;
    }

    private Map<Long, String> getAllTemplateFilesMap() {
        return ((Holder)this.holderRef.get()).templateFileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTemplateContent(Long templateId, String format) {
        String templateContent = null;
        String templateFileName = this.getTemplateFilename(templateId);
        String resourceName = EMAIL_TEMPLATES + format + "/" + templateFileName;
        BufferedReader reader = null;
        try {
            int len;
            reader = new BufferedReader(new InputStreamReader(ClassLoaderUtils.getResourceAsStream((String)resourceName, this.getClass()), this.applicationProperties.getString("webwork.i18n.encoding")));
            StringWriter stringWriter = new StringWriter();
            char[] buf = new char[1024];
            while ((len = reader.read(buf, 0, 1024)) != -1) {
                stringWriter.write(buf, 0, len);
            }
            templateContent = stringWriter.toString();
        }
        catch (Exception e) {
            log.error("Problem retrieving template [" + resourceName + "]", (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                log.error("Could not close the file '" + resourceName + "'.");
            }
        }
        return templateContent;
    }

    private String getTemplateFilename(Long templateId) {
        return this.getAllTemplateFilesMap().get(templateId);
    }

    private Holder initTemplates() {
        ImmutableMap.Builder templatesMap = ImmutableMap.builder();
        ImmutableMap.Builder templateFileMap = ImmutableMap.builder();
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)templateIDMappingConfigFile, DefaultTemplateManager.class);
        try {
            Document doc = new Document(is);
            Element root = doc.getRoot();
            Elements actions = root.getElements("templatemapping");
            while (actions.hasMoreElements()) {
                Element action = (Element)actions.nextElement();
                Long id = new Long(action.getAttributeValue("id"));
                String name = action.getElement("name").getTextString();
                String templateFile = action.getElement("template").getTextString();
                String templateType = action.getElement("templatetype").getTextString();
                Template template = new Template(id, name, null, null, null, templateType);
                templatesMap.put((Object)id, (Object)template);
                templateFileMap.put((Object)id, (Object)templateFile);
            }
        }
        catch (ParseException e) {
            log.error("Error parsing email-template-id-mappings.xml: " + (Object)((Object)e), (Throwable)e);
        }
        try {
            is.close();
        }
        catch (IOException e) {
            log.warn("Could not close template id mappings inputStream.", (Throwable)e);
        }
        return new Holder((ImmutableMap<Long, Template>)templatesMap.build(), (ImmutableMap<Long, String>)templateFileMap.build());
    }

    @EventListener
    public void onCacheClear(ClearCacheEvent event) {
        this.holderRef.reset();
    }

    static class Holder {
        final ImmutableMap<Long, Template> templatesMap;
        final ImmutableMap<Long, String> templateFileMap;

        Holder(ImmutableMap<Long, Template> templatesMap, ImmutableMap<Long, String> templateFileMap) {
            this.templatesMap = templatesMap;
            this.templateFileMap = templateFileMap;
        }
    }
}

