/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.jira.util.dbc.Assertions;
import java.io.Serializable;
import java.util.Date;

public class TaskProgressEvent
implements Serializable {
    private static final long serialVersionUID = -3295135558200242598L;
    private final Date creationTimeStamp;
    private final Long taskId;
    private final long elapsedRunTime;
    private final long taskProgress;
    private final String message;
    private final String currentSubTask;

    public TaskProgressEvent(Long taskId, long elapsedRunTime, long taskProgress, String currentSubTask, String message) {
        Assertions.notNull((String)"taskId", (Object)taskId);
        this.taskId = taskId;
        this.elapsedRunTime = elapsedRunTime;
        this.taskProgress = taskProgress;
        this.currentSubTask = currentSubTask;
        this.message = message;
        this.creationTimeStamp = new Date();
    }

    public String getCurrentSubTask() {
        return this.currentSubTask;
    }

    public long getElapsedRunTime() {
        return this.elapsedRunTime;
    }

    public long getTaskProgress() {
        return this.taskProgress;
    }

    public Date getCreationTimeStamp() {
        return new Date(this.creationTimeStamp.getTime());
    }

    public String getMessage() {
        return this.message;
    }

    public Long getTaskId() {
        return this.taskId;
    }
}

