/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClusterSafe(value="Local object")
class ForkedThreadExecutor
extends AbstractExecutorService {
    private static final Logger log = LoggerFactory.getLogger(ForkedThreadExecutor.class);
    private final int maxThreads;
    private final Queue<Runnable> waitingTasks = new LinkedList<Runnable>();
    private final ThreadFactory threadFactory;
    private final Set<ForkedRunnableDecorator> executingTasks = new HashSet<ForkedRunnableDecorator>();
    private boolean shutdown;

    ForkedThreadExecutor(int maxThreads, @Nonnull ThreadFactory threadFactory) {
        Assertions.notNull((String)"threadFactory", (Object)threadFactory);
        if (maxThreads <= 0) {
            throw new IllegalArgumentException("maxThreads must be > 0");
        }
        this.threadFactory = threadFactory;
        this.maxThreads = maxThreads;
        this.setShutdown(false);
    }

    ForkedThreadExecutor(int maxThreads) {
        this(maxThreads, new DefaultThreadFactory());
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public void shutdown() {
        this.setShutdown(true);
    }

    @Override
    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        this.shutdown();
        if (log.isDebugEnabled()) {
            log.debug("Called shutdownNow. Interrupting " + this.executingTasks.size() + " threads and returning " + this.waitingTasks.size() + " queued tasks.");
        }
        Iterator<ForkedRunnableDecorator> iterator = this.executingTasks.iterator();
        while (iterator.hasNext()) {
            ForkedRunnableDecorator element;
            ForkedRunnableDecorator o = element = iterator.next();
            Thread th = o.getThread();
            th.interrupt();
        }
        ArrayList<Runnable> returningTasks = new ArrayList<Runnable>(this.waitingTasks);
        this.waitingTasks.clear();
        this.notifyAll();
        return returningTasks;
    }

    @Override
    public synchronized boolean isTerminated() {
        return this.isShutdown() && this.executingTasks.isEmpty() && this.waitingTasks.isEmpty();
    }

    @Override
    public synchronized boolean awaitTermination(long length, @Nonnull TimeUnit timeUnit) throws InterruptedException {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        if (log.isDebugEnabled()) {
            log.debug("Called awaitTermination. Awaiting " + length + " " + (Object)((Object)timeUnit) + ".");
        }
        if (length > 0L) {
            length = timeUnit.toMillis(length);
            long startTime = System.currentTimeMillis();
            while (!this.isTerminated()) {
                long diff = System.currentTimeMillis() - startTime;
                if (diff < length) {
                    if (log.isDebugEnabled()) {
                        log.debug("Waiting " + (length - diff) + " ms for executor to terminate.");
                    }
                    this.wait(length - diff);
                    continue;
                }
                if (!log.isDebugEnabled()) break;
                log.debug("Timed out for executor to terminate.");
                break;
            }
        }
        return this.isTerminated();
    }

    @Override
    public synchronized void execute(@Nonnull Runnable runnable) {
        Assertions.notNull((String)"runnable", (Object)runnable);
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Executor has been shutdown.");
        }
        if (this.executingTasks.size() >= this.maxThreads) {
            if (log.isDebugEnabled()) {
                log.debug("Adding new task to waiting queue. ExecutingTasks=" + this.executingTasks.size() + ", WaitingTasks=" + this.waitingTasks.size());
            }
            this.waitingTasks.offer(runnable);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Starting new task. ExecutingTasks=" + this.executingTasks.size() + ", WaitingTasks=" + this.waitingTasks.size());
            }
            if (!this.waitingTasks.isEmpty()) {
                Runnable nextRunnable = this.waitingTasks.remove();
                this.waitingTasks.offer(runnable);
                runnable = nextRunnable;
            }
            this.startThread(runnable);
        }
    }

    private synchronized void finishedTask(ForkedRunnableDecorator runnableDecorator) {
        if (log.isDebugEnabled()) {
            log.debug("Finished executing task. ExecutingTasks=" + this.executingTasks.size() + ", WaitingTasks=" + this.waitingTasks.size());
        }
        this.executingTasks.remove(runnableDecorator);
        if (!this.waitingTasks.isEmpty()) {
            log.debug("Starting next task in queue.");
            Runnable nextRunnable = this.waitingTasks.remove();
            this.startThread(nextRunnable);
        }
        this.notifyAll();
    }

    private synchronized void startThread(Runnable runnable) {
        ForkedRunnableDecorator runnableDecorator = new ForkedRunnableDecorator(runnable);
        Thread thread = this.threadFactory.newThread(runnableDecorator);
        runnableDecorator.setThread(thread);
        this.executingTasks.add(runnableDecorator);
        thread.start();
    }

    private synchronized void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
        this.notifyAll();
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicInteger idCounter = new AtomicInteger(0);

        DefaultThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String title = "ForkedThreadExecutor-runner-" + this.idCounter.getAndIncrement();
            return new Thread(runnable, title);
        }
    }

    private class ForkedRunnableDecorator
    implements Runnable {
        private final Runnable runnable;
        private Thread thread;

        public ForkedRunnableDecorator(Runnable runnable) {
            this.runnable = runnable;
            this.thread = null;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            finally {
                ForkedThreadExecutor.this.finishedTask(this);
            }
        }

        public Thread getThread() {
            return this.thread;
        }

        public void setThread(Thread thread) {
            this.thread = thread;
        }
    }
}

