/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.index.request.TaskDescriptorHelper;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushStaleReindexLauncher {
    private static final Logger log = LoggerFactory.getLogger(FlushStaleReindexLauncher.class);

    public void start() {
        this.flushStaleForegroundIndexTask();
    }

    public void stop() {
    }

    private void flushStaleForegroundIndexTask() {
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        TaskManager taskManager = (TaskManager)ComponentAccessor.getComponent(TaskManager.class);
        TaskDescriptorHelper taskDescriptorHelper = new TaskDescriptorHelper(taskManager);
        TaskDescriptor<IndexCommandResult> activeIndexTask = taskDescriptorHelper.getActiveForegroundIndexTask();
        if (activeIndexTask != null) {
            if (Objects.equals(activeIndexTask.getNodeId(), clusterManager.getNodeId())) {
                log.info("Removing stale foreground reindex task '{}' assigned to this node, index might be inconsistent", (Object)activeIndexTask.getTaskId());
                taskManager.removeTask(activeIndexTask.getTaskId());
            } else {
                log.debug("Foreground reindex is currently running on another node '{}' - do nothing", (Object)activeIndexTask.getNodeId());
            }
        } else {
            log.debug("There is no stale foreground reindex in the cluster");
        }
    }
}

