/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.index.DirectoryFactory;
import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.store.Directory;

public class IndexPathDirectoryFactory
implements DirectoryFactory {
    private final IndexPathManager pathManager;
    private final LuceneDirectoryUtils luceneDirectoryUtils;

    public IndexPathDirectoryFactory(IndexPathManager pathManager, LuceneDirectoryUtils luceneDirectoryUtils) {
        this.luceneDirectoryUtils = (LuceneDirectoryUtils)Assertions.notNull((String)"luceneDirectoryUtils", (Object)luceneDirectoryUtils);
        this.pathManager = (IndexPathManager)Assertions.notNull((String)"path", (Object)pathManager);
    }

    public Directory apply(SharedEntity.TypeDescriptor<?> type) {
        return this.luceneDirectoryUtils.getDirectory(new File(this.getIndexPath(type)));
    }

    public String getIndexPath(SharedEntity.TypeDescriptor<?> type) {
        return this.pathManager.getSharedEntityIndexPath() + "/" + type.getName().toLowerCase();
    }

    public Path getIndexSubPath(SharedEntity.TypeDescriptor<?> type) {
        return Paths.get(this.pathManager.getIndexRootPath(), new String[0]).relativize(Paths.get(this.getIndexPath(type), new String[0]));
    }
}

