/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.johnson.DefaultJohnsonProvider;
import com.atlassian.jira.util.johnson.JiraJohnsonContainer;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.system.status.ApplicationState;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApplicationStatusServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationState state = this.getApplicationState();
        resp.setStatus(state == ApplicationState.ERROR ? 500 : 200);
        resp.setContentType("application/json");
        resp.getWriter().append("{\"state\":\"").append(state.name()).append("\"}");
    }

    private ApplicationState getApplicationState() {
        if (ApplicationStatusServlet.anyJohnsonEventsPreventStartup()) {
            return ApplicationState.ERROR;
        }
        if (!this.hasStarted()) {
            return ApplicationState.STARTING;
        }
        if (ApplicationStatusServlet.isFirstRun()) {
            return ApplicationState.FIRST_RUN;
        }
        if (ApplicationStatusServlet.anyJohnsonEventsExist()) {
            return ApplicationState.MAINTENANCE;
        }
        return ApplicationState.RUNNING;
    }

    private static boolean anyJohnsonEventsPreventStartup() {
        return ApplicationStatusServlet.getJohnsonContainer().hasEventThatPreventsStartup();
    }

    private static boolean anyJohnsonEventsExist() {
        return !ApplicationStatusServlet.getJohnsonContainer().getEvents().isEmpty();
    }

    private boolean hasStarted() {
        ComponentManager.State state = this.getState();
        return state.isComponentsRegistered() && state.isContainerInitialised() && state.isPluginSystemStarted() && state.isStarted();
    }

    @VisibleForTesting
    protected ComponentManager.State getState() {
        return ComponentManager.getInstance().getState();
    }

    private static JiraJohnsonContainer getJohnsonContainer() {
        return ComponentAccessor.getComponentSafely(JohnsonProvider.class).orElseGet(DefaultJohnsonProvider::new).getContainer();
    }

    private static boolean isFirstRun() {
        return !JiraUtils.isSetUp();
    }
}

