/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.auditing;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.auditing.AuditingRetentionPeriod;
import com.atlassian.jira.auditing.AuditingStore;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.service.AbstractService;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogCleaningService
extends AbstractService {
    private static final Logger log = LoggerFactory.getLogger(AuditLogCleaningService.class);
    private final AuditingStore auditingStore;
    private final ApplicationProperties applicationProperties;

    public AuditLogCleaningService(AuditingStore auditingStore, ApplicationProperties applicationProperties) {
        this.auditingStore = auditingStore;
        this.applicationProperties = applicationProperties;
    }

    public void run() {
        AuditingRetentionPeriod retentionPeriod = this.configuredRetentionPeriod();
        if (retentionPeriod != null && !retentionPeriod.isUnlimited()) {
            DateTime monthsIntoPast = retentionPeriod.monthsIntoPast();
            if (log.isDebugEnabled()) {
                log.debug("Removing log entries older than " + monthsIntoPast);
            }
            long entriesRemoved = this.auditingStore.removeRecordsOlderThan(monthsIntoPast.getMillis());
            if (log.isDebugEnabled()) {
                log.debug("Removed " + entriesRemoved + " entries");
            }
        } else {
            log.debug("Log entries are kept indefinitely");
        }
    }

    private AuditingRetentionPeriod configuredRetentionPeriod() {
        return AuditingRetentionPeriod.getByValue(this.applicationProperties.getDefaultBackedString("jira.option.auditing.log.retention.period.in.months"));
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("AUDITLOGCLEANINGSERVICE", "services/com/atlassian/jira/service/services/auditing/auditlogcleaningservice.xml", null);
    }
}

