/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service;

import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.service.JiraService;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.JiraServiceContainerImpl;
import com.atlassian.jira.service.ServiceConfigStore;
import com.atlassian.jira.service.ServiceException;
import com.atlassian.jira.service.UnloadableJiraServiceContainer;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.JiraUtils;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizServiceConfigStore
implements ServiceConfigStore {
    private static final Logger log = LoggerFactory.getLogger(OfBizServiceConfigStore.class);
    private static final String ENTITY_NAME = "ServiceConfig";
    private static final String SERVICE_CONFIG_ID = "id";
    private static final String SERVICE_CONFIG_NAME = "name";
    private static final String SERVICE_CONFIG_TIME = "time";
    private static final String SERVICE_CONFIG_CRON = "cronExpression";
    private static final String SERVICE_CONFIG_CLAZZ = "clazz";
    private static final String JIRA_PLUGIN_SCHEDULER_SERVICE = "com.atlassian.sal.jira.scheduling.JiraPluginSchedulerService";
    private static final int JIRA_PLUGIN_SCHEDULER_SERVICE_REMOVED_BUILD = 63000;
    private final OfBizDelegator ofBizDelegator;
    private final ComponentClassManager componentClassManager;
    private static final String CANT_CREATE_SERVICE_MSG = "Unable to create a service config for service with the name : %s ";
    private static final String UNABLE_TO_FIND_CLASS_MSG = "The class '%s' could not be found.  This can happen when a plugin is uninstalled or disabled";
    private static final String A_NO_OP_SERVICE_HAS_BEEN_RETURNED_MSG = "A NoOp Service has been returned and hence '%s' will not do anything until fixed.";

    public OfBizServiceConfigStore(OfBizDelegator ofBizDelegator, ComponentClassManager componentClassManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.componentClassManager = componentClassManager;
    }

    @Override
    public JiraServiceContainer addServiceConfig(String serviceName, Class<? extends JiraService> serviceClass, long serviceDelay) throws ServiceException {
        return this.addServiceConfig(serviceName, serviceClass, null, serviceDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JiraServiceContainer addServiceConfig(String serviceName, Class<? extends JiraService> serviceClass, String cronExpression, Long serviceDelay) throws ServiceException {
        this.validateServiceConfigDetails(serviceName, serviceClass, serviceDelay, cronExpression);
        String serviceClassName = serviceClass.getName();
        JiraService jiraService = JiraUtils.loadComponent(serviceClass);
        GenericValue serviceConfig = this.ofBizDelegator.createValue(ENTITY_NAME, (Map)FieldMap.build((String)SERVICE_CONFIG_NAME, (Object)serviceName, (String)SERVICE_CONFIG_CLAZZ, (Object)serviceClassName, (String)SERVICE_CONFIG_TIME, (Object)serviceDelay, (String)SERVICE_CONFIG_CRON, (Object)cronExpression));
        boolean success = false;
        try {
            PropertySet ps = this.createPropertySet(serviceConfig, jiraService, new HashMap<String, String[]>());
            JiraServiceContainer serviceContainer = OfBizServiceConfigStore.instantiateServiceContainer(jiraService, serviceConfig, ps);
            success = true;
            JiraServiceContainer jiraServiceContainer = serviceContainer;
            return jiraServiceContainer;
        }
        finally {
            if (!success) {
                this.ofBizDelegator.removeValue(serviceConfig);
            }
        }
    }

    @Override
    public void editServiceConfig(JiraServiceContainer serviceContainer, String cronExpression, Map<String, String[]> params) throws ServiceException {
        this.editServiceConfig(serviceContainer, null, cronExpression, params);
    }

    @Override
    public void editServiceConfig(JiraServiceContainer serviceContainer, long delay, Map<String, String[]> params) throws ServiceException {
        this.editServiceConfig(serviceContainer, delay, null, params);
    }

    private void editServiceConfig(JiraServiceContainer config, Long delay, String cronExpression, Map<String, String[]> params) throws ServiceException {
        GenericValue serviceConfigGV = this.getGenericValueForConfig(config);
        if (log.isDebugEnabled()) {
            log.debug("Editing service  with id '" + serviceConfigGV.getLong(SERVICE_CONFIG_ID) + "'.");
        }
        PropertySet ps = this.createPropertySet(serviceConfigGV, (JiraService)config, params);
        if (delay != null) {
            serviceConfigGV.set(SERVICE_CONFIG_TIME, (Object)delay);
        }
        serviceConfigGV.set(SERVICE_CONFIG_CRON, (Object)cronExpression);
        this.ofBizDelegator.store(serviceConfigGV);
        config.setDelay(serviceConfigGV.getLong(SERVICE_CONFIG_TIME).longValue());
        config.setCronExpression(serviceConfigGV.getString(SERVICE_CONFIG_CRON));
        try {
            config.init(ps);
        }
        catch (ObjectConfigurationException ex) {
            throw new ServiceException("An error occurred when initialising Service '" + config.getName() + "'.", (Exception)((Object)ex));
        }
    }

    @Override
    public void removeServiceConfig(JiraServiceContainer config) {
        GenericValue serviceConfigGV = this.getGenericValueForConfig(config);
        this.removePropertySet(serviceConfigGV);
        this.ofBizDelegator.removeValue(serviceConfigGV);
    }

    void removePropertySet(GenericValue serviceConfigGV) {
        OFBizPropertyUtils.removePropertySet(serviceConfigGV);
    }

    @Override
    @Nullable
    public JiraServiceContainer getServiceConfigForName(String name) {
        List services = this.ofBizDelegator.findByAnd(ENTITY_NAME, (Map)FieldMap.build((String)SERVICE_CONFIG_NAME, (Object)name));
        if (services == null || services.isEmpty()) {
            return null;
        }
        if (services.size() > 1) {
            throw new IllegalArgumentException("Multiple services with name '" + name + "' exist.");
        }
        return this.getServiceContainer((GenericValue)services.get(0));
    }

    @Override
    @Nullable
    public JiraServiceContainer getServiceConfigForId(Long id) {
        GenericValue serviceConfigGV = this.ofBizDelegator.findById(ENTITY_NAME, id);
        if (serviceConfigGV != null) {
            return this.getServiceContainer(serviceConfigGV);
        }
        return null;
    }

    @Override
    public Collection<JiraServiceContainer> getAllServiceConfigs() {
        int dbBuildNumber = ((BuildUtilsInfo)ComponentAccessor.getComponent(BuildUtilsInfo.class)).getDatabaseBuildNumber();
        if (dbBuildNumber < 63000) {
            this.ofBizDelegator.removeByAnd(ENTITY_NAME, (Map)FieldMap.build((String)SERVICE_CONFIG_CLAZZ, (Object)JIRA_PLUGIN_SCHEDULER_SERVICE));
        }
        List serviceConfigGVs = this.ofBizDelegator.findAll(ENTITY_NAME);
        ArrayList<JiraServiceContainer> serviceConfigs = new ArrayList<JiraServiceContainer>(serviceConfigGVs.size());
        for (GenericValue element : serviceConfigGVs) {
            serviceConfigs.add(this.getServiceContainer(element));
        }
        return serviceConfigs;
    }

    GenericValue getGenericValueForConfig(JiraServiceContainer config) {
        return this.ofBizDelegator.findByPrimaryKey(ENTITY_NAME, (Map)FieldMap.build((String)SERVICE_CONFIG_ID, (Object)config.getId()));
    }

    private JiraServiceContainer getServiceContainer(GenericValue serviceConfigGV) {
        PropertySet ps = OFBizPropertyUtils.getCachingPropertySet(serviceConfigGV);
        try {
            return this.instantiateServiceContainer(serviceConfigGV, ps);
        }
        catch (ClassNotFoundServiceException cnfse) {
            String serviceName = serviceConfigGV.getString(SERVICE_CONFIG_NAME);
            log.error(String.format(CANT_CREATE_SERVICE_MSG, serviceName), (Throwable)((Object)cnfse));
            log.error(String.format(UNABLE_TO_FIND_CLASS_MSG, cnfse.getClazzName()));
            log.error(String.format(A_NO_OP_SERVICE_HAS_BEEN_RETURNED_MSG, serviceName));
        }
        catch (ServiceException se) {
            log.error(String.format(CANT_CREATE_SERVICE_MSG, serviceConfigGV.getString(SERVICE_CONFIG_NAME)), (Throwable)se);
        }
        catch (Exception e) {
            log.error(String.format(CANT_CREATE_SERVICE_MSG, serviceConfigGV.getString(SERVICE_CONFIG_NAME)), (Throwable)e);
        }
        Long delay = serviceConfigGV.getLong(SERVICE_CONFIG_TIME);
        return new UnloadableJiraServiceContainer(serviceConfigGV.getLong(SERVICE_CONFIG_ID), serviceConfigGV.getString(SERVICE_CONFIG_NAME), serviceConfigGV.getString(SERVICE_CONFIG_CLAZZ), delay == null ? -1L : delay, serviceConfigGV.getString(SERVICE_CONFIG_CRON));
    }

    private JiraServiceContainer instantiateServiceContainer(GenericValue serviceConfigGV, PropertySet ps) throws ServiceException {
        String className = serviceConfigGV.getString(SERVICE_CONFIG_CLAZZ);
        try {
            JiraService service = this.loadServiceClass(className);
            return OfBizServiceConfigStore.instantiateServiceContainer(service, serviceConfigGV, ps);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundServiceException("Could not find class: " + className, className, e);
        }
    }

    private static JiraServiceContainer instantiateServiceContainer(JiraService service, GenericValue serviceConfigGV, PropertySet ps) throws ServiceException {
        Long id = serviceConfigGV.getLong(SERVICE_CONFIG_ID);
        try {
            JiraServiceContainerImpl jiraServiceContainer = new JiraServiceContainerImpl(service, id);
            jiraServiceContainer.init(ps, id);
            jiraServiceContainer.setName(serviceConfigGV.getString(SERVICE_CONFIG_NAME));
            Long delay = serviceConfigGV.getLong(SERVICE_CONFIG_TIME);
            jiraServiceContainer.setDelay(delay == null ? -1L : delay);
            jiraServiceContainer.setCronExpression(serviceConfigGV.getString(SERVICE_CONFIG_CRON));
            return jiraServiceContainer;
        }
        catch (ObjectConfigurationException e) {
            throw new ServiceException("Could not initialize service '" + service.getName() + "'.", (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            throw new ServiceException("Error creating service '" + service.getName() + "'.", (Exception)e);
        }
    }

    private PropertySet createPropertySet(GenericValue serviceGV, JiraService service, Map<String, String[]> properties) throws ServiceException {
        String[] fieldKeys;
        PropertySet ps = OFBizPropertyUtils.getCachingPropertySet(serviceGV);
        try {
            fieldKeys = service.getObjectConfiguration().getFieldKeys();
        }
        catch (ObjectConfigurationException ex) {
            throw new ServiceException("Unable to get ObjectConfiguration for Service '" + service.getName() + "'.", (Exception)((Object)ex));
        }
        for (String paramName : fieldKeys) {
            if (properties.containsKey(paramName)) {
                String paramValue = properties.get(paramName)[0];
                if (!TextUtils.stringSet((String)paramValue)) {
                    paramValue = null;
                }
                if (paramValue != null) {
                    ps.setString(paramName, paramValue);
                    continue;
                }
                ps.remove(paramName);
                continue;
            }
            ps.remove(paramName);
        }
        return ps;
    }

    private void validateServiceConfigDetails(String serviceName, Class<? extends JiraService> serviceClass, Long serviceDelay, String cronExpression) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            throw new ServiceException("The service name must not be blank.");
        }
        if (serviceClass == null) {
            throw new ServiceException("The service class must not be null.");
        }
        if (serviceDelay == null && StringUtils.isBlank((CharSequence)cronExpression)) {
            throw new ServiceException("The service delay or cron expression is required");
        }
        if (serviceDelay != null && serviceDelay <= 0L) {
            throw new ServiceException("The service delay must be greater than 0.");
        }
    }

    private JiraService loadServiceClass(String serviceClassName) throws ClassNotFoundException {
        return (JiraService)this.componentClassManager.newInstance(serviceClassName);
    }

    private static class ClassNotFoundServiceException
    extends ServiceException {
        private final String clazzName;

        private ClassNotFoundServiceException(String msg, String clazzName, Exception e) {
            super(msg, e);
            this.clazzName = clazzName;
        }

        public String getClazzName() {
            return this.clazzName;
        }
    }
}

