/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servermetrics;

import com.atlassian.jira.servermetrics.RequestKeyResolver;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.http.HttpServletRequest;

@NotThreadSafe
public class NestedRequestKeyResolver {
    private Optional<String> requestKey = Optional.empty();
    private int referenceCount;
    private final RequestKeyResolver requestKeyResolver;

    public NestedRequestKeyResolver(RequestKeyResolver requestKeyResolver) {
        this.requestKeyResolver = requestKeyResolver;
    }

    public void requestStarted(HttpServletRequest httpServletRequest) {
        ++this.referenceCount;
    }

    public Optional<String> requestFinished(HttpServletRequest httpServletRequest) {
        if (!this.requestKey.isPresent()) {
            this.requestKey = this.guessRequestKey(httpServletRequest);
        }
        Optional<String> result = this.requestKey;
        --this.referenceCount;
        if (this.referenceCount <= 0) {
            this.referenceCount = 0;
            this.requestKey = Optional.empty();
        }
        return result;
    }

    private Optional<String> guessRequestKey(HttpServletRequest httpServletRequest) {
        return this.requestKeyResolver.getRequestId(httpServletRequest);
    }
}

