/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.xsrf.BootstrapXsrfTokenGenerator;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class XsrfTokenAdditionRequestFilter
implements Filter {
    private static final String ALREADY_FILTERED = XsrfTokenAdditionRequestFilter.class.getName() + "_already_filtered";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest.getAttribute(ALREADY_FILTERED) != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        servletRequest.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
        this.setXsrfToken((HttpServletRequest)servletRequest);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private void setXsrfToken(HttpServletRequest httpServletRequest) {
        this.getXsrfTokenGenerator().generateToken(httpServletRequest);
    }

    @VisibleForTesting
    XsrfTokenGenerator getXsrfTokenGenerator() {
        return ComponentAccessor.getComponentSafely(XsrfTokenGenerator.class).orElseGet(BootstrapXsrfTokenGenerator::new);
    }
}

