/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.type.AbstractProjectsSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserUtil;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class GroupDropdown
extends AbstractProjectsSecurityType {
    public static final String DESC = "group";
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public GroupDropdown(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.group");
    }

    @Override
    public String getType() {
        return DESC;
    }

    @Override
    public boolean hasPermission(Project project, String group) {
        return group == null;
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter) {
        return parameter == null;
    }

    @Override
    public boolean hasPermission(Project project, String parameter, ApplicationUser user, boolean issueCreation) {
        return this.hasPermission(parameter, user);
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter, ApplicationUser user, boolean issueCreation) {
        return this.hasPermission(parameter, user);
    }

    private boolean hasPermission(String groupName, ApplicationUser user) {
        if (user == null) {
            throw new IllegalArgumentException("User passed must not be null");
        }
        if (groupName == null) {
            return true;
        }
        GroupManager groupManager = ComponentAccessor.getGroupManager();
        return groupManager.isUserInGroup(user, groupName);
    }

    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
    }

    @Override
    public Set<ApplicationUser> getUsers(PermissionContext ctx, String groupName) {
        if (groupName == null) {
            return Sets.newHashSet((Iterable)UserUtils.getAllUsers());
        }
        return Sets.newHashSet((Iterable)this.getUserUtil().getAllUsersInGroupNamesUnsorted(Collections.singletonList(groupName)));
    }

    private UserUtil getUserUtil() {
        return ComponentAccessor.getUserUtil();
    }
}

