/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles.actor;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.model.querydsl.QProjectRoleActor;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.security.roles.actor.AbstractRoleActor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public class UserRoleActorFactory
implements RoleActorFactory {
    private final UserManager userManager;
    private final DbConnectionManager dbConnectionManager;

    public UserRoleActorFactory(UserManager userManager, DbConnectionManager dbConnectionManager) {
        this.userManager = userManager;
        this.dbConnectionManager = dbConnectionManager;
    }

    public ProjectRoleActor createRoleActor(Long id, Long projectRoleId, Long projectId, String type, String parameter) {
        if (!"atlassian-user-role-actor".equals(type)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot create RoleActors of type: " + type);
        }
        Assertions.notNull((String)"parameter", (Object)parameter);
        return new UserRoleActor(id, projectRoleId, projectId, parameter);
    }

    public Set<RoleActor> optimizeRoleActorSet(Set<RoleActor> roleActors) {
        HashSet<RoleActor> originals = new HashSet<RoleActor>(roleActors);
        HashSet<UserRoleActor> userRoleActors = new HashSet<UserRoleActor>(roleActors.size());
        Iterator it = originals.iterator();
        while (it.hasNext()) {
            RoleActor roleActor = (RoleActor)it.next();
            if (!(roleActor instanceof UserRoleActor)) continue;
            userRoleActors.add((UserRoleActor)roleActor);
            it.remove();
        }
        if (!userRoleActors.isEmpty()) {
            if (userRoleActors.size() > 1) {
                UserRoleActor prototype = (UserRoleActor)((Object)userRoleActors.iterator().next());
                originals.add((RoleActor)new AggregateRoleActor((ProjectRoleActor)prototype, userRoleActors));
            } else {
                originals.addAll(userRoleActors);
            }
        }
        return Collections.unmodifiableSet(originals);
    }

    @Nonnull
    public Set<ProjectRoleActor> getAllRoleActorsForUser(@Nullable ApplicationUser user) {
        if (user == null) {
            return ImmutableSet.of();
        }
        String userKey = user.getKey();
        ImmutableSet.Builder resultsBuilder = ImmutableSet.builder();
        this.dbConnectionManager.execute(dbConnection -> {
            QProjectRoleActor pra = new QProjectRoleActor("pra");
            List roleActorTuples = ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(new Expression[]{pra.id, pra.pid, pra.projectroleid, pra.roletype, pra.roletypeparameter}).from((Expression)pra)).where((com.querydsl.core.types.Predicate)pra.roletype.eq((Object)"atlassian-user-role-actor").and((com.querydsl.core.types.Predicate)pra.roletypeparameter.eq((Object)user.getKey())).and((com.querydsl.core.types.Predicate)pra.pid.isNotNull()))).fetch();
            roleActorTuples.stream().map(tuple -> new UserRoleActor((Tuple)tuple, pra, userKey)).forEach(arg_0 -> ((ImmutableSet.Builder)resultsBuilder).add(arg_0));
        });
        return resultsBuilder.build();
    }

    static class AggregateRoleActor
    extends AbstractRoleActor {
        private final Map<String, UserRoleActor> userRoleActorMap;

        private AggregateRoleActor(ProjectRoleActor prototype, Set<UserRoleActor> roleActors) {
            super(null, prototype.getProjectRoleId(), prototype.getProjectId(), null);
            HashMap<String, UserRoleActor> map = new HashMap<String, UserRoleActor>(roleActors.size());
            for (UserRoleActor userRoleActor : roleActors) {
                map.put(userRoleActor.getParameter(), userRoleActor);
            }
            this.userRoleActorMap = Collections.unmodifiableMap(map);
        }

        public boolean isActive() {
            return Iterables.all(this.userRoleActorMap.values(), (Predicate)new Predicate<UserRoleActor>(){

                public boolean apply(@Nullable UserRoleActor user) {
                    return user != null && user.isActive();
                }
            });
        }

        public boolean contains(ApplicationUser user) {
            return user != null && this.userRoleActorMap.containsKey(user.getKey()) && this.userRoleActorMap.get(user.getKey()).contains(user);
        }

        public Set<ApplicationUser> getUsers() {
            HashSet<ApplicationUser> result = new HashSet<ApplicationUser>(this.userRoleActorMap.size());
            for (UserRoleActor roleActor : this.userRoleActorMap.values()) {
                result.addAll(roleActor.getUsers());
            }
            return Collections.unmodifiableSet(result);
        }

        public String getType() {
            return "atlassian-user-role-actor";
        }
    }

    class UserRoleActor
    extends AbstractRoleActor {
        private UserRoleActor(Long id, Long projectRoleId, Long projectId, String key) {
            super(id, projectRoleId, projectId, key);
        }

        @Deprecated
        private UserRoleActor(Long id, Long projectRoleId, Long projectId, ApplicationUser user) {
            super(id, projectRoleId, projectId, ApplicationUsers.getKeyFor(user));
        }

        private UserRoleActor(Tuple tuple, QProjectRoleActor projectRoleActor, String userKey) {
            super((Long)tuple.get(projectRoleActor.id), (Long)tuple.get(projectRoleActor.projectroleid), (Long)tuple.get(projectRoleActor.pid), userKey);
        }

        public String getType() {
            return "atlassian-user-role-actor";
        }

        public boolean isActive() {
            return this.getUser().isActive();
        }

        public String getDescriptor() {
            return this.getAppUser().getDisplayName();
        }

        public Set<ApplicationUser> getUsers() {
            return CollectionBuilder.newBuilder((Object[])new ApplicationUser[]{this.getUser()}).asSet();
        }

        public boolean contains(ApplicationUser user) {
            return user != null && user.getKey().equals(this.getParameter());
        }

        private ApplicationUser getAppUser() {
            return UserRoleActorFactory.this.userManager.getUserByKeyEvenWhenUnknown(this.getParameter());
        }

        private ApplicationUser getUser() {
            return UserRoleActorFactory.this.userManager.getUserByKeyEvenWhenUnknown(this.getParameter());
        }
    }
}

