/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.login;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.elevatedsecurity.ElevatedSecurityGuard;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;

public class JiraElevatedSecurityGuard
implements ElevatedSecurityGuard {
    private static final AtomicReference<SecurityConfig> SECURITY_CONFIG = new AtomicReference();

    public boolean performElevatedSecurityCheck(HttpServletRequest httpServletRequest, String userName) {
        return this.getLoginManager().performElevatedSecurityCheck(httpServletRequest, userName);
    }

    public void onFailedLoginAttempt(HttpServletRequest httpServletRequest, String userName) {
        this.getLoginManager().onLoginAttempt(httpServletRequest, userName, false);
    }

    public void onSuccessfulLoginAttempt(HttpServletRequest httpServletRequest, String userName) {
        this.getLoginManager().onLoginAttempt(httpServletRequest, userName, true);
    }

    public void init(Map<String, String> params, SecurityConfig config) {
        SECURITY_CONFIG.set(config);
    }

    LoginManager getLoginManager() {
        return (LoginManager)ComponentAccessor.getComponentSafely(LoginManager.class).orElseThrow(() -> new RuntimeException("Login not available, JIRA not ready yet"));
    }

    public static boolean isInitialised() {
        return SECURITY_CONFIG.get() != null;
    }
}

