/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeAddedToProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeCopiedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeComparator;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Named;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemeManager
implements SchemeManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSchemeManager.class);
    static final String PROJECT_ENTITY_NAME = "Project";
    private final Cache<Long, List<GenericValue>> projectSchemeCache;
    protected final ProjectManager projectManager;
    protected final SecurityTypeManager securityTypeManager;
    private final PermissionContextFactory permissionContextFactory;
    protected final SchemeFactory schemeFactory;
    private final NodeAssociationStore nodeAssociationStore;
    private final OfBizDelegator ofBizDelegator;
    protected final GroupManager groupManager;
    protected final EventPublisher eventPublisher;

    protected AbstractSchemeManager(ProjectManager projectManager, SecurityTypeManager securityTypeManager, PermissionContextFactory permissionContextFactory, SchemeFactory schemeFactory, NodeAssociationStore nodeAssociationStore, OfBizDelegator ofBizDelegator, GroupManager groupManager, EventPublisher eventPublisher, CacheManager cacheManager) {
        this.projectManager = projectManager;
        this.securityTypeManager = securityTypeManager;
        this.permissionContextFactory = permissionContextFactory;
        this.schemeFactory = schemeFactory;
        this.nodeAssociationStore = nodeAssociationStore;
        this.ofBizDelegator = ofBizDelegator;
        this.groupManager = groupManager;
        this.eventPublisher = eventPublisher;
        this.projectSchemeCache = cacheManager.getCache(this.getClass().getName() + ".projectSchemeCache", this::loadProjectSchemeCache, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    public void onClearCache(ClearCacheEvent event) {
        this.flushProjectSchemes();
    }

    public abstract String getSchemeEntityName();

    public abstract String getEntityName();

    public abstract String getSchemeDesc();

    public abstract String getDefaultNameKey();

    public abstract String getDefaultDescriptionKey();

    @Deprecated
    public String getAssociationType() {
        return "ProjectScheme";
    }

    protected abstract GenericValue createSchemeEntityNoEvent(GenericValue var1, SchemeEntity var2) throws GenericEntityException;

    public GenericValue getScheme(Long id) {
        return this.ofBizDelegator.findById(this.getSchemeEntityName(), id);
    }

    @Nullable
    public Scheme getSchemeObject(Long id) throws DataAccessException {
        return this.toScheme(this.getScheme(id));
    }

    @Nullable
    public Scheme getSchemeObject(String name) throws DataAccessException {
        return this.toScheme(this.getScheme(name));
    }

    public GenericValue getScheme(String name) throws DataAccessException {
        FieldMap fields = FieldMap.build((String)"name", (Object)name);
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd(this.getSchemeEntityName(), (Map)fields));
    }

    public List<GenericValue> getSchemes() throws DataAccessException {
        List schemes = this.ofBizDelegator.findAll(this.getSchemeEntityName());
        Collections.sort(schemes, OfBizComparators.NAME_COMPARATOR);
        return schemes;
    }

    public List<Scheme> getSchemeObjects() throws DataAccessException {
        List schemeGvs = this.ofBizDelegator.findAll(this.getSchemeEntityName());
        Collections.sort(schemeGvs, OfBizComparators.NAME_COMPARATOR);
        return this.schemeFactory.getSchemes(schemeGvs);
    }

    public List<Scheme> getAssociatedSchemes(boolean withEntitiesComparable) throws DataAccessException {
        return this.getSchemeObjects().stream().filter(scheme -> !this.getProjects((Scheme)scheme).isEmpty()).map(scheme -> withEntitiesComparable ? this.schemeFactory.getSchemeWithEntitiesComparable(this.getScheme(scheme.getId())) : scheme).collect(Collectors.toList());
    }

    public List<Scheme> getUnassociatedSchemes() throws DataAccessException {
        return this.getSchemeObjects().stream().filter(scheme -> this.getProjects((Scheme)scheme).isEmpty()).sorted(new SchemeComparator()).collect(Collectors.toList());
    }

    public List<GenericValue> getSchemes(GenericValue project) throws GenericEntityException {
        if (project == null) {
            throw new IllegalArgumentException("Cannot get schemes for null project");
        }
        Long id = project.getLong("id");
        return (List)this.projectSchemeCache.get((Object)id);
    }

    @Nullable
    public Scheme getSchemeFor(Project project) {
        try {
            List<GenericValue> schemes = this.getSchemes(project.getGenericValue());
            if (schemes.isEmpty()) {
                return null;
            }
            if (schemes.size() > 1) {
                throw new IllegalStateException("Too many " + this.getSchemeEntityName() + " schemes found for Project " + project.getKey());
            }
            return this.schemeFactory.getScheme(schemes.iterator().next());
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException((Throwable)ex);
        }
    }

    @Nullable
    public Long getSchemeIdFor(Project project) {
        try {
            List<GenericValue> schemes = this.getSchemes(project.getGenericValue());
            if (schemes.isEmpty()) {
                return null;
            }
            if (schemes.size() > 1) {
                throw new IllegalStateException("Too many " + this.getSchemeEntityName() + " schemes found for Project " + project.getKey());
            }
            return schemes.get(0).getLong("id");
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException((Throwable)ex);
        }
    }

    public GenericValue getEntity(Long id) {
        return this.ofBizDelegator.findById(this.getEntityName(), id);
    }

    public List<GenericValue> getEntities(String type, String parameter) throws GenericEntityException {
        List result = this.ofBizDelegator.findByAnd(this.getEntityName(), (Map)FieldMap.build((String)"type", (Object)type, (String)"parameter", (Object)parameter));
        return result;
    }

    public List<GenericValue> getEntitiesByIds(List<Long> ids) {
        EntityExpr idsOfEntities = new EntityExpr("id", EntityOperator.IN, (Object)ImmutableList.copyOf(ids));
        return Select.from(this.getEntityName()).whereCondition((EntityCondition)idsOfEntities).runWith(this.ofBizDelegator).asList();
    }

    public List<GenericValue> getEntities(GenericValue scheme) throws GenericEntityException {
        return this.ofBizDelegator.getRelated("Child" + this.getEntityName(), scheme);
    }

    public boolean schemeExists(String name) {
        return this.getScheme(name) != null;
    }

    public GenericValue createScheme(String name, String description) throws GenericEntityException {
        GenericValue newScheme = this.createSchemeNoEvent(name, description);
        this.eventPublisher.publish((Object)this.createSchemeCreatedEvent(this.schemeFactory.getScheme(newScheme)));
        return newScheme;
    }

    protected GenericValue createSchemeNoEvent(String name, String description) throws GenericEntityException {
        if (!this.schemeExists(name)) {
            this.flushProjectSchemes();
            return this.createSchemeGenericValue(MapBuilder.build((Object)"name", (Object)name, (Object)"description", (Object)description));
        }
        throw new GenericEntityException("Could not create " + this.getSchemeDesc() + " Scheme with name:" + name + " as it already exists.");
    }

    protected abstract AbstractSchemeEvent createSchemeCreatedEvent(Scheme var1);

    public Scheme createSchemeObject(String name, String description) {
        try {
            return this.schemeFactory.getScheme(this.createScheme(name, description));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public Scheme createSchemeAndEntities(Scheme scheme) throws DataAccessException {
        GenericValue schemeGV;
        if (scheme == null) {
            throw new IllegalArgumentException();
        }
        try {
            schemeGV = this.createScheme(scheme.getName(), scheme.getDescription());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        Collection schemeEntities = scheme.getEntities();
        ArrayList entityGVs = Lists.newArrayListWithCapacity((int)schemeEntities.size());
        for (SchemeEntity schemeEntity : schemeEntities) {
            try {
                entityGVs.add(this.createSchemeEntity(schemeGV, schemeEntity));
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
        return this.schemeFactory.getScheme(schemeGV, entityGVs);
    }

    protected abstract AbstractSchemeUpdatedEvent createSchemeUpdatedEvent(Scheme var1, Scheme var2);

    public void updateScheme(GenericValue entity) throws GenericEntityException {
        Long schemeId = entity.getLong("id");
        Scheme originalScheme = this.getSchemeObject(schemeId);
        entity.store();
        this.flushProjectSchemes();
        this.eventPublisher.publish((Object)this.createSchemeUpdatedEvent(this.getSchemeObject(schemeId), originalScheme));
    }

    public void updateScheme(Scheme scheme) throws DataAccessException {
        try {
            GenericValue schemeEntity = this.getScheme(scheme.getId());
            schemeEntity.setString("name", scheme.getName());
            schemeEntity.setString("description", scheme.getDescription());
            this.updateScheme(schemeEntity);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void deleteScheme(Long id) throws GenericEntityException {
        if (id != null && id != 0L) {
            GenericValue scheme = this.getScheme(id);
            this.nodeAssociationStore.removeAssociationsFromSink(scheme);
            this.ofBizDelegator.removeRelated("Child" + this.getEntityName(), scheme);
            this.ofBizDelegator.removeValue(scheme);
            this.flushProjectSchemes();
        }
    }

    @Deprecated
    public void addSchemeToProject(GenericValue project, GenericValue scheme) throws GenericEntityException {
        this.addSchemeToProject(this.projectManager.getProjectObj(project.getLong("id")), this.schemeFactory.getScheme(scheme));
    }

    public void addSchemeToProject(Project project, Scheme scheme) throws DataAccessException {
        if (project == null) {
            throw new IllegalArgumentException("The project passed can not be null.");
        }
        if (scheme == null) {
            throw new IllegalArgumentException("The scheme passed can not be null.");
        }
        try {
            List<GenericValue> schemes = this.getSchemes(project.getGenericValue());
            GenericValue schemeGV = this.getScheme(scheme.getId());
            if (!schemes.contains(schemeGV)) {
                this.nodeAssociationStore.createAssociation(project.getGenericValue(), schemeGV, this.getAssociationType());
            }
            this.flushProjectSchemes();
            this.eventPublisher.publish((Object)this.createSchemeAddedToProjectEvent(scheme, project));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Nonnull
    protected abstract AbstractSchemeAddedToProjectEvent createSchemeAddedToProjectEvent(Scheme var1, Project var2);

    public void removeSchemesFromProject(Project project) throws DataAccessException {
        try {
            this.removeSchemesFromProject(project.getGenericValue());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Deprecated
    public void removeSchemesFromProject(GenericValue project) throws GenericEntityException {
        List<GenericValue> schemes = this.getSchemes(project);
        for (GenericValue scheme : schemes) {
            this.nodeAssociationStore.removeAssociation(project, scheme, this.getAssociationType());
            this.eventPublisher.publish((Object)this.createSchemeRemovedFromProjectEvent(this.schemeFactory.getScheme(scheme), this.projectManager.getProjectObj(project.getLong("id"))));
        }
        this.flushProjectSchemes();
    }

    @Nonnull
    protected abstract AbstractSchemeRemovedFromProjectEvent createSchemeRemovedFromProjectEvent(Scheme var1, Project var2);

    public void deleteEntity(Long id) throws DataAccessException {
        try {
            GenericValue entity = this.getEntity(id);
            entity.remove();
            this.publishSchemeEntityDeletedEvent(entity);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void deleteEntities(Iterable<Long> ids) throws DataAccessException {
        if (Iterables.isEmpty(ids)) {
            return;
        }
        EntityExpr idsOfEntities = new EntityExpr("id", EntityOperator.IN, (Object)ImmutableList.copyOf(ids));
        List deletedEntities = Select.from(this.getEntityName()).whereCondition((EntityCondition)idsOfEntities).runWith(this.ofBizDelegator).asList();
        Delete.from(this.getEntityName()).whereCondition((EntityCondition)idsOfEntities).execute(this.ofBizDelegator);
        deletedEntities.forEach(this::publishSchemeEntityDeletedEvent);
    }

    public void swapParameterForEntitiesOfType(String type, String parameter, String resultingParameter) {
        Update.into(this.getEntityName()).set("parameter", resultingParameter).whereEqual("parameter", parameter).andEqual("type", type).execute(this.ofBizDelegator);
        this.flushProjectSchemes();
    }

    private void publishSchemeEntityDeletedEvent(GenericValue entity) {
        Object event = this.createSchemeEntityDeletedEvent(entity);
        if (event != null) {
            this.eventPublisher.publish(event);
        }
    }

    protected abstract SchemeEntity makeSchemeEntity(GenericValue var1);

    @Nullable
    protected abstract Object createSchemeEntityDeletedEvent(GenericValue var1);

    public List<Project> getProjects(Scheme scheme) throws DataAccessException {
        if (scheme == null || scheme.getId() == null) {
            throw new IllegalArgumentException("The scheme and the schemes id can not be null");
        }
        GenericValue schemeGV = this.getScheme(scheme.getId());
        List<Long> projectIds = this.nodeAssociationStore.getSourceIdsFromSink(schemeGV, PROJECT_ENTITY_NAME, this.getAssociationType());
        List<Project> projects = projectIds.stream().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0)).filter(Objects::nonNull).sorted(Named.NAME_COMPARATOR).collect(Collectors.toList());
        if (projectIds.size() != projects.size()) {
            Set foundProjectIds = projects.stream().map(Project::getId).collect(Collectors.toSet());
            String unknownProjectIds = Sets.difference((Set)Sets.newHashSet(projectIds), (Set)Sets.newHashSet(foundProjectIds)).stream().map(String::valueOf).collect(Collectors.joining(", "));
            LOG.warn("The provided scheme {} has node associations to project ids '{}' that have not been mapped to any actual projects. Potential data consistency problem.", (Object)scheme, (Object)unknownProjectIds);
        }
        return projects;
    }

    public GenericValue createDefaultScheme() throws GenericEntityException {
        if (this.getDefaultScheme() == null) {
            return this.createSchemeGenericValue(MapBuilder.build((Object)"id", (Object)0L, (Object)"name", (Object)this.getI18nTextWithDefaultNullCheck(this.getDefaultNameKey(), "Default " + this.getSchemeDesc() + " Scheme"), (Object)"description", (Object)this.getI18nTextWithDefaultNullCheck(this.getDefaultDescriptionKey(), "This is the default " + this.getSchemeDesc() + " Scheme. Any new projects that are created will be assigned this scheme")));
        }
        return this.getDefaultScheme();
    }

    public boolean removeEntities(String type, String parameter) throws RemoveException {
        if (type == null) {
            throw new IllegalArgumentException("Type passed must not be null");
        }
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter passed must not be null");
        }
        try {
            List<GenericValue> entities = this.getEntities(type, parameter);
            this.ofBizDelegator.removeAll(entities);
            return true;
        }
        catch (GenericEntityException e) {
            throw new RemoveException((Exception)((Object)e));
        }
    }

    public boolean removeEntities(GenericValue scheme, Long entityTypeId) throws RemoveException {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme passed to this function must not be NULL");
        }
        try {
            List entities = this.getEntities(scheme, entityTypeId);
            this.ofBizDelegator.removeAll(entities);
            return true;
        }
        catch (GenericEntityException e) {
            throw new RemoveException((Exception)((Object)e));
        }
    }

    public GenericValue getDefaultScheme() throws GenericEntityException {
        return this.ofBizDelegator.findById(this.getSchemeEntityName(), Long.valueOf(0L));
    }

    public Scheme getDefaultSchemeObject() {
        try {
            GenericValue defaultSchemeGV = this.getDefaultScheme();
            if (defaultSchemeGV == null) {
                return null;
            }
            return this.schemeFactory.getScheme(defaultSchemeGV);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void addDefaultSchemeToProject(GenericValue project) throws GenericEntityException {
        List<GenericValue> schemes;
        GenericValue scheme = this.getDefaultScheme();
        if (scheme != null && !(schemes = this.getSchemes(project)).contains(scheme)) {
            this.nodeAssociationStore.createAssociation(project, scheme, this.getAssociationType());
        }
        this.flushProjectSchemes();
    }

    public void addDefaultSchemeToProject(Project project) throws DataAccessException {
        try {
            this.addDefaultSchemeToProject(project.getGenericValue());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public GenericValue copyScheme(GenericValue oldScheme) throws GenericEntityException {
        if (oldScheme == null) {
            return null;
        }
        String name = this.getNameForCopy(oldScheme.getString("name"), null);
        GenericValue newScheme = this.createSchemeNoEvent(name, oldScheme.getString("description"));
        List<GenericValue> origEntities = this.getEntities(oldScheme);
        for (GenericValue entity : origEntities) {
            this.createSchemeEntityNoEvent(newScheme, this.makeSchemeEntity(entity));
        }
        this.eventPublisher.publish((Object)this.createSchemeCopiedEvent(this.schemeFactory.getScheme(oldScheme), this.schemeFactory.getScheme(newScheme)));
        return newScheme;
    }

    public String getNameForCopy(String originalName, Integer abbreviateTo) {
        I18nHelper i18n = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        String name = i18n.getText("common.words.copyof", originalName);
        if (abbreviateTo != null) {
            name = StringUtils.abbreviate((String)name, (int)abbreviateTo);
        }
        int j = 2;
        while (this.schemeExists(name)) {
            name = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("common.words.copyxof", String.valueOf(j++), originalName);
            if (abbreviateTo == null) continue;
            name = StringUtils.abbreviate((String)name, (int)abbreviateTo);
        }
        return name;
    }

    @Nonnull
    protected abstract AbstractSchemeCopiedEvent createSchemeCopiedEvent(@Nonnull Scheme var1, @Nonnull Scheme var2);

    public Scheme copyScheme(Scheme oldScheme) {
        try {
            GenericValue newSchemeGv = this.copyScheme(this.getScheme(oldScheme.getId()));
            return this.schemeFactory.getScheme(newSchemeGv);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    protected void flushProjectSchemes() {
        this.projectSchemeCache.removeAll();
    }

    public Collection<Group> getGroups(Long entityTypeId, Project project) {
        return this.getGroups(entityTypeId, project.getGenericValue());
    }

    public Collection<Group> getGroups(Long entityTypeId, GenericValue project) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed can NOT be null");
        }
        if (!PROJECT_ENTITY_NAME.equals(project.getEntityName())) {
            throw new IllegalArgumentException("Project passed must be a project not a " + project.getEntityName());
        }
        HashSet<Group> groups = new HashSet<Group>();
        try {
            List<GenericValue> schemes = this.getSchemes(project);
            for (GenericValue scheme : schemes) {
                List entity = this.getEntities(scheme, "group", entityTypeId);
                groups.addAll(entity.stream().map(permission -> this.groupManager.getGroup(permission.getString("parameter"))).collect(Collectors.toList()));
            }
        }
        catch (GenericEntityException e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
        return groups;
    }

    public Collection<ApplicationUser> getUsers(Long permissionId, GenericValue projectOrIssue) {
        return this.getUsers(permissionId, this.permissionContextFactory.getPermissionContext(projectOrIssue));
    }

    public Collection<ApplicationUser> getUsers(Long permissionId, Project project) {
        return this.getUsers(permissionId, this.permissionContextFactory.getPermissionContext(project));
    }

    public Collection<ApplicationUser> getUsers(Long permissionId, Issue issue) {
        return this.getUsers(permissionId, this.permissionContextFactory.getPermissionContext(issue));
    }

    public Collection<ApplicationUser> getUsers(Long permissionId, PermissionContext ctx) {
        HashSet<ApplicationUser> users = new HashSet<ApplicationUser>();
        Map permTypes = this.securityTypeManager.getTypes();
        try {
            List<GenericValue> schemes = this.getSchemes(ctx.getProject());
            for (GenericValue scheme : schemes) {
                List entities = this.getEntities(scheme, permissionId);
                for (GenericValue entity : entities) {
                    SecurityType secType = (SecurityType)permTypes.get(entity.getString("type"));
                    if (secType == null) continue;
                    try {
                        Set<ApplicationUser> usersToAdd = secType.getUsers(ctx, entity.getString("parameter"));
                        users.addAll(usersToAdd.stream().filter(ApplicationUser::isActive).collect(Collectors.toList()));
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (GenericEntityException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return users;
    }

    protected GenericValue createSchemeGenericValue(Map<String, Object> values) throws GenericEntityException {
        return this.ofBizDelegator.createValue(this.getSchemeEntityName(), values);
    }

    private String getI18nTextWithDefaultNullCheck(String key, String defaultResult) {
        if (key == null) {
            return defaultResult;
        }
        String result = this.getApplicationI18n().getText(key);
        if (result.equals(key)) {
            return defaultResult;
        }
        return result;
    }

    protected I18nHelper getApplicationI18n() {
        return new I18nBean();
    }

    @Nullable
    private Scheme toScheme(GenericValue schemeGv) {
        return schemeGv != null ? this.schemeFactory.getScheme(schemeGv) : null;
    }

    @Nonnull
    private List<GenericValue> loadProjectSchemeCache(@Nonnull Long projectId) {
        return ImmutableList.copyOf(this.nodeAssociationStore.getSinksFromSource(PROJECT_ENTITY_NAME, projectId, this.getSchemeEntityName(), this.getAssociationType()));
    }
}

