/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler;

import com.atlassian.jira.entity.AbstractEntityFactory;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.scheduler.OfBizClusteredJob;
import com.atlassian.scheduler.caesium.impl.ImmutableClusteredJob;
import com.atlassian.scheduler.caesium.spi.ClusteredJob;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.ofbiz.core.entity.GenericValue;

public class ClusteredJobFactory
extends AbstractEntityFactory<OfBizClusteredJob> {
    public static final String ID = "id";
    public static final String JOB_ID = "jobId";
    public static final String JOB_RUNNER_KEY = "jobRunnerKey";
    public static final String SCHED_TYPE = "schedType";
    public static final String INTERVAL_MILLIS = "intervalMillis";
    public static final String FIRST_RUN = "firstRun";
    public static final String CRON_EXPRESSION = "cronExpression";
    public static final String TIME_ZONE = "timeZone";
    public static final String NEXT_RUN = "nextRun";
    public static final String VERSION = "version";
    public static final String PARAMETERS = "parameters";
    public static final String TYPE_INTERVAL = "I";
    public static final String TYPE_CRON = "C";

    @Override
    public OfBizClusteredJob build(GenericValue genericValue) {
        return new OfBizClusteredJob(genericValue.getLong(ID), (ClusteredJob)ImmutableClusteredJob.builder().jobId(JobId.of((String)genericValue.getString(JOB_ID))).jobRunnerKey(JobRunnerKey.of((String)genericValue.getString(JOB_RUNNER_KEY))).schedule(ClusteredJobFactory.getSchedule(genericValue)).nextRunTime(ClusteredJobFactory.toDate(genericValue.getLong(NEXT_RUN))).version(genericValue.getLong(VERSION).longValue()).parameters((byte[])genericValue.get(PARAMETERS)).build());
    }

    @Override
    public Map<String, Object> fieldMapFrom(OfBizClusteredJob value) {
        FieldMap fields = new FieldMap().add(ID, (Object)value.getId()).add(JOB_ID, (Object)value.getJobId().toString()).add(JOB_RUNNER_KEY, (Object)value.getJobRunnerKey().toString()).add(NEXT_RUN, (Object)ClusteredJobFactory.toLong(value.getNextRunTime())).add(VERSION, (Object)value.getVersion()).add(PARAMETERS, (Object)value.getRawParameters());
        ClusteredJobFactory.addScheduleInfo(fields, value.getSchedule());
        return fields;
    }

    @Override
    public String getEntityName() {
        return "ClusteredJob";
    }

    private static Schedule getSchedule(GenericValue genericValue) {
        Schedule.Type type = ClusteredJobFactory.toScheduleType(genericValue.getString(SCHED_TYPE));
        switch (type) {
            case INTERVAL: {
                return Schedule.forInterval((long)genericValue.getLong(INTERVAL_MILLIS), (Date)ClusteredJobFactory.toDate(genericValue.getLong(FIRST_RUN)));
            }
            case CRON_EXPRESSION: {
                return Schedule.forCronExpression((String)genericValue.getString(CRON_EXPRESSION), (TimeZone)ClusteredJobFactory.toTimeZone(genericValue.getString(TIME_ZONE)));
            }
        }
        throw ClusteredJobFactory.badType(type);
    }

    private static void addScheduleInfo(FieldMap fields, Schedule schedule) {
        switch (schedule.getType()) {
            case INTERVAL: {
                fields.add(SCHED_TYPE, (Object)TYPE_INTERVAL);
                fields.add(INTERVAL_MILLIS, (Object)schedule.getIntervalScheduleInfo().getIntervalInMillis());
                fields.add(FIRST_RUN, (Object)ClusteredJobFactory.toLong(schedule.getIntervalScheduleInfo().getFirstRunTime()));
                return;
            }
            case CRON_EXPRESSION: {
                fields.add(SCHED_TYPE, (Object)TYPE_CRON);
                fields.add(CRON_EXPRESSION, (Object)schedule.getCronScheduleInfo().getCronExpression());
                fields.add(TIME_ZONE, (Object)ClusteredJobFactory.toTimeZoneId(schedule.getCronScheduleInfo().getTimeZone()));
                return;
            }
        }
        throw ClusteredJobFactory.badType(schedule.getType());
    }

    private static Schedule.Type toScheduleType(String value) {
        if (value != null && value.length() == 1) {
            switch (value.charAt(0)) {
                case 'C': {
                    return Schedule.Type.CRON_EXPRESSION;
                }
                case 'I': {
                    return Schedule.Type.INTERVAL;
                }
            }
        }
        throw ClusteredJobFactory.badType(value);
    }

    private static TimeZone toTimeZone(String zoneId) {
        return zoneId != null ? TimeZone.getTimeZone(zoneId) : null;
    }

    private static String toTimeZoneId(TimeZone timeZone) {
        return timeZone != null ? timeZone.getID() : null;
    }

    private static Date toDate(Long date) {
        return date != null ? new Date(date) : null;
    }

    private static Long toLong(Date date) {
        return date != null ? Long.valueOf(date.getTime()) : null;
    }

    private static IllegalArgumentException badType(Object scheduleType) {
        return new IllegalArgumentException("Unsupported schedule type: " + scheduleType);
    }
}

