/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.dataimport.DatabaseImportCompletedEvent;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.SqlCallback;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.model.querydsl.JiraRelationalPathBase;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyText;
import com.atlassian.jira.propertyset.OfBizPropertyEntryStore;
import com.atlassian.jira.propertyset.OfBizPropertyTypeRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.io.Serializable;
import java.sql.SQLTransactionRollbackException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
@ParametersAreNonnullByDefault
public class CachingOfBizPropertyEntryStore
implements OfBizPropertyEntryStore {
    private static final Logger LOG = LoggerFactory.getLogger(CachingOfBizPropertyEntryStore.class);
    static final int BATCH_SIZE = 900;
    private static final int MAX_ATTEMPTS = 5;
    private final QueryDslAccessor queryDslAccessor;
    private final Cache<CacheKey, PropertySetData> cache;

    public CachingOfBizPropertyEntryStore(QueryDslAccessor queryDslAccessor, CacheManager cacheManager) {
        this.queryDslAccessor = Objects.requireNonNull(queryDslAccessor, "queryDslAccessor");
        this.cache = cacheManager.getCache(CachingOfBizPropertyEntryStore.class.getName() + ".cache", this::loadPropertySetData, new CacheSettingsBuilder().expireAfterAccess(1L, TimeUnit.DAYS).flushable().build());
    }

    private PropertySetData resolve(String entityName, long entityId) {
        CacheKey cacheKey = new CacheKey(entityName, entityId);
        try {
            return (PropertySetData)this.cache.get((Object)cacheKey);
        }
        catch (RuntimeException re) {
            throw CachingOfBizPropertyEntryStore.propEx("Unable to load values for " + cacheKey, re);
        }
    }

    @Override
    @Nonnull
    public Collection<String> getKeys(String entityName, long entityId) {
        return this.resolve(entityName, entityId).keys();
    }

    @Override
    @Nonnull
    public Collection<String> getKeys(String entityName, long entityId, int type) {
        return this.resolve(entityName, entityId).keys(type);
    }

    @Override
    public OfBizPropertyEntryStore.PropertyEntry getEntry(String entityName, long entityId, String propertyKey) {
        return this.resolve(entityName, entityId).get(propertyKey);
    }

    @Override
    public boolean exists(String entityName, long entityId, String propertyKey) {
        return this.getType(entityName, entityId, propertyKey) > 0;
    }

    @Override
    public int getType(String entityName, long entityId, String propertyKey) {
        return this.resolve(entityName, entityId).getType(propertyKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEntry(String entityName, long entityId, String propertyKey, int type, Object value) {
        try {
            CachingOfBizPropertyEntryStore.retry(this.createSetOperation(entityName, entityId, propertyKey, type, value));
        }
        finally {
            this.invalidateCacheEntry(entityName, entityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(String entityName, long entityId, String propertyKey) {
        try {
            CachingOfBizPropertyEntryStore.retry(this.createRemoveOperation(entityName, entityId, propertyKey));
        }
        finally {
            this.invalidateCacheEntry(entityName, entityId);
        }
    }

    protected Operation createRemoveOperation(String entityName, long entityId, String propertyKey) {
        return new RemoveOperation(entityName, entityId, propertyKey);
    }

    protected Operation createSetOperation(String entityName, long entityId, String propertyKey, int type, Object value) {
        return new SetOperation(entityName, entityId, propertyKey, type, value);
    }

    @Override
    public void removePropertySet(String entityName, long entityId) {
        try {
            this.execute(db -> {
                List<Tuple> rows = this.loadIdsAndTypes(entityName, entityId);
                db.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)entityName)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)entityId)).execute();
                CachingOfBizPropertyEntryStore.removeValues(db, rows);
            });
        }
        catch (QueryException qe) {
            throw CachingOfBizPropertyEntryStore.propEx(qe);
        }
        finally {
            this.invalidateCacheEntry(entityName, entityId);
        }
    }

    static void removeValues(DbConnection db, List<Tuple> idsAndTypes) {
        CachingOfBizPropertyEntryStore.groupByValuePath(idsAndTypes).forEach((path, ids) -> CachingOfBizPropertyEntryStore.deleteById(db, path, ids));
    }

    private static Map<JiraRelationalPathBase<?>, List<Long>> groupByValuePath(List<Tuple> idsAndTypes) {
        IdentityHashMap idsByValueTable = new IdentityHashMap(4);
        idsAndTypes.forEach(idAndType -> {
            Long id = (Long)idAndType.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id);
            Integer type = (Integer)idAndType.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type);
            try {
                JiraRelationalPathBase<?> path = OfBizPropertyTypeRegistry.mapper(type).getValueTable();
                idsByValueTable.computeIfAbsent(path, key -> new ArrayList()).add(id);
            }
            catch (PropertyImplementationException pie) {
                LOG.warn("Ignoring property entry with invalid type: id={}, type={}", (Object)id, (Object)type);
            }
        });
        return idsByValueTable;
    }

    private static void deleteById(DbConnection db, JiraRelationalPathBase<?> path, Collection<Long> ids) {
        ArrayList<Long> list = new ArrayList<Long>(ids);
        Lists.partition(list, (int)900).forEach(subList -> {
            try {
                db.delete((RelationalPath<?>)path).where((Predicate)path.getNumericIdPath().in((Collection)subList)).execute();
            }
            catch (QueryException qe) {
                LOG.warn("Unable to remove property set values from {}: {}", new Object[]{path.getSchemaAndTable(), ids, qe});
            }
        });
    }

    public void invalidateCacheEntry(String entityName, long entityId) {
        this.cache.remove((Object)new CacheKey(entityName, entityId));
    }

    public void refreshAll() {
        this.cache.removeAll();
    }

    @EventListener
    public void onClearCache(@Nullable ClearCacheEvent event) {
        this.refreshAll();
    }

    @EventListener
    public void onDatabaseImportCompleted(DatabaseImportCompletedEvent event) {
        this.refreshAll();
    }

    private List<Tuple> loadIdsAndTypes(String entityName, long entityId) {
        return this.query(db -> ((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.id, QOSPropertyEntry.O_S_PROPERTY_ENTRY.type}).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)entityName))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)entityId))).fetch());
    }

    @VisibleForTesting
    PropertySetData loadPropertySetData(CacheKey cacheKey) {
        return new PropertySetData(cacheKey.entityName, cacheKey.entityId);
    }

    private void execute(SqlCallback callback) {
        this.queryDslAccessor.withNewConnection().execute(callback);
    }

    private <T> T query(QueryCallback<T> callback) {
        return this.queryDslAccessor.withNewConnection().executeQuery(callback);
    }

    private <T> T tx(QueryCallback<T> callback) {
        return (T)this.query(db -> {
            db.setAutoCommit(false);
            Object result = callback.runQuery(db);
            db.commit();
            return result;
        });
    }

    private static void retry(Operation operation) {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    if (!operation.perform()) continue;
                    return;
                }
                catch (QueryException qex) {
                    if (qex.getCause() instanceof SQLTransactionRollbackException) {
                        LOG.debug("Possible deadlock detected, retry transaction", (Object)qex.getMessage());
                        continue;
                    }
                    throw qex;
                }
            }
        }
        catch (RuntimeException re) {
            Throwables.propagateIfInstanceOf((Throwable)re, PropertyImplementationException.class);
            throw CachingOfBizPropertyEntryStore.propEx("Failed operation: " + operation, re);
        }
        throw new PropertyImplementationException("Failed operation (too many retries): " + operation);
    }

    private static PropertyImplementationException propEx(Throwable cause) {
        PropertyImplementationException ex = new PropertyImplementationException(cause);
        ex.initCause(cause);
        throw ex;
    }

    private static PropertyImplementationException propEx(String message, Throwable cause) {
        PropertyImplementationException ex = new PropertyImplementationException(message, cause);
        ex.initCause(cause);
        throw ex;
    }

    class RemoveOperation
    extends Operation {
        RemoveOperation(String entityName, long entityId, String propertyKey) {
            super(entityName, entityId, propertyKey);
        }

        @Override
        boolean perform() {
            return (Boolean)CachingOfBizPropertyEntryStore.this.tx(this::deleteEntryAndValue);
        }

        boolean deleteEntryAndValue(DbConnection db) {
            List idsAndTypes = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.id, QOSPropertyEntry.O_S_PROPERTY_ENTRY.type}).forUpdate()).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)this.entityName))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)this.entityId))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)this.propertyKey))).orderBy(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.desc())).fetch();
            return idsAndTypes.isEmpty() || this.deleteEntriesAndValues(db, idsAndTypes);
        }

        boolean deleteEntriesAndValues(DbConnection db, List<Tuple> idsAndTypes) {
            int type;
            Tuple first = idsAndTypes.get(0);
            long id = (Long)Objects.requireNonNull(first.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id));
            if (!this.deleteEntry(db, id, type = ((Integer)Objects.requireNonNull(first.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type))).intValue())) {
                LOG.warn("SELECT FOR UPDATE is broken.  operation={}", (Object)this);
                return false;
            }
            if (idsAndTypes.size() > 1) {
                db.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)this.entityName)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)this.entityId)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)this.propertyKey)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.lt((Number)id)).execute();
            }
            CachingOfBizPropertyEntryStore.removeValues(db, idsAndTypes);
            return true;
        }

        boolean deleteEntry(DbConnection db, long id, int type) {
            return db.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq((Object)id)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type.eq((Object)type)).execute() > 0L;
        }

        @Override
        public String toString() {
            return "RemoveOperation[entityName=" + this.entityName + ",entityId=" + this.entityId + ",propertyKey=" + this.propertyKey + ']';
        }
    }

    class SetOperation
    extends Operation {
        private final int newType;
        private final OfBizPropertyTypeRegistry.TypeMapper newMapper;
        private final Object mappedValue;

        SetOperation(String entityName, long entityId, String propertyKey, @Nullable int type, Object unmappedValue) {
            super(entityName, entityId, propertyKey);
            this.newType = type;
            this.newMapper = OfBizPropertyTypeRegistry.mapper(type);
            this.mappedValue = unmappedValue != null ? OfBizPropertyTypeRegistry.mapper(type).getHandler().processSet(type, unmappedValue) : null;
        }

        @Override
        boolean perform() {
            return (Boolean)CachingOfBizPropertyEntryStore.this.tx(this::upsert);
        }

        private boolean upsert(DbConnection db) {
            List existing = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.id, QOSPropertyEntry.O_S_PROPERTY_ENTRY.type}).forUpdate()).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)this.entityName))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)this.entityId))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)this.propertyKey))).orderBy(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.desc())).fetch();
            return existing.isEmpty() ? this.insert(db) : this.update(db, existing);
        }

        private boolean insert(DbConnection db) {
            long id = db.insert(QOSPropertyEntry.O_S_PROPERTY_ENTRY).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName, this.entityName).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId, (Object)this.entityId).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey, this.propertyKey).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type, (Object)this.newType).executeWithId();
            this.newMapper.insert(db, id, this.mappedValue);
            return true;
        }

        private boolean update(DbConnection db, List<Tuple> idsAndTypes) {
            Integer oldType;
            Tuple idAndType = idsAndTypes.get(0);
            Long id = (Long)Objects.requireNonNull(idAndType.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id), "id");
            if (this.update(db, id, oldType = (Integer)Objects.requireNonNull(idAndType.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type), "type"))) {
                this.deleteDuplicates(db, id, idsAndTypes);
                return true;
            }
            return false;
        }

        private void deleteDuplicates(DbConnection db, Long id, List<Tuple> idsAndTypes) {
            if (idsAndTypes.size() < 2) {
                return;
            }
            db.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)this.entityName)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)this.entityId)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)this.propertyKey)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.lt((Number)id)).execute();
            CachingOfBizPropertyEntryStore.removeValues(db, idsAndTypes.subList(1, idsAndTypes.size()));
        }

        private boolean update(DbConnection db, Long id, int oldType) {
            return oldType != this.newType ? this.updateTypeAndValue(db, id, oldType) : this.upsertValue(db, id);
        }

        private boolean updateTypeAndValue(DbConnection db, Long id, int oldType) {
            if (!this.updateType(db, id, oldType)) {
                LOG.warn("SELECT FOR UPDATE is broken: operation={}; oldType={}", (Object)this, (Object)oldType);
                return false;
            }
            OfBizPropertyTypeRegistry.TypeMapper oldMapper = OfBizPropertyTypeRegistry.mapper(oldType);
            return this.newMapper.hasSameEntityName(oldMapper) ? this.upsertValue(db, id) : this.moveValue(db, id, oldMapper);
        }

        private boolean moveValue(DbConnection db, Long id, OfBizPropertyTypeRegistry.TypeMapper oldMapper) {
            oldMapper.delete(db, id);
            this.newMapper.insert(db, id, this.mappedValue);
            return true;
        }

        private boolean updateType(DbConnection db, long id, int oldType) {
            return db.update((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).set(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type, (Object)this.newType).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq((Object)id)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type.eq((Object)oldType)).execute() > 0L;
        }

        private boolean upsertValue(DbConnection db, Long id) {
            return this.newMapper.upsert(db, id, this.mappedValue);
        }

        @Override
        public String toString() {
            return "SetOperation[entityName=" + this.entityName + ",entityId=" + this.entityId + ",propertyKey=" + this.propertyKey + ",newType=" + this.newType + ",newMapper=" + this.newMapper + ']';
        }
    }

    static abstract class Operation {
        final String entityName;
        final long entityId;
        final String propertyKey;

        protected Operation(String entityName, long entityId, String propertyKey) {
            this.entityName = entityName;
            this.entityId = entityId;
            this.propertyKey = propertyKey;
        }

        abstract boolean perform();

        public abstract String toString();
    }

    class PropertySetData {
        private final String entityName;
        private final long entityId;
        private final Map<String, Integer> keysAndTypes;
        private final Map<String, Map<String, Object>> valuesByMapperEntityName = new ConcurrentHashMap<String, Map<String, Object>>(4);
        private final Map<String, Optional<String>> textValuesCache = new ConcurrentHashMap<String, Optional<String>>();

        PropertySetData(String entityName, long entityId) {
            this.entityName = entityName;
            this.entityId = entityId;
            this.keysAndTypes = this.loadPropertyKeysAndTypes(entityName, entityId);
        }

        Set<String> keys() {
            return this.keysAndTypes.keySet();
        }

        Set<String> keys(int type) {
            return (Set)this.keysAndTypes.entrySet().stream().filter(entry -> type == (Integer)entry.getValue()).map(Map.Entry::getKey).collect(CollectorsUtil.toImmutableSet());
        }

        int getType(String key) {
            Integer type = this.keysAndTypes.get(key);
            return type != null ? type : 0;
        }

        @Nullable
        OfBizPropertyEntryStore.PropertyEntry get(String key) {
            Integer type = this.keysAndTypes.get(key);
            return type != null ? this.get(key, type) : null;
        }

        private OfBizPropertyEntryStore.PropertyEntry get(String key, int type) {
            OfBizPropertyTypeRegistry.TypeMapper mapper = OfBizPropertyTypeRegistry.mapper(type);
            if (type == 6) {
                return this.textValuesCache.computeIfAbsent(key, this::getText).map(value -> new PropertyEntryImpl(6, value)).orElse(null);
            }
            return new PropertyEntryImpl(type, this.bulkLoad(mapper).get(key));
        }

        private Map<String, Integer> loadPropertyKeysAndTypes(String entityName, long entityId) {
            List rows = (List)CachingOfBizPropertyEntryStore.this.query(db -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey, QOSPropertyEntry.O_S_PROPERTY_ENTRY.type}).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)entityName))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)entityId))).orderBy(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.desc())).fetch());
            return this.asMap(rows, (Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type);
        }

        private Optional<String> getText(String key) {
            List list = (List)CachingOfBizPropertyEntryStore.this.query(db -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select((Expression)QOSPropertyText.O_S_PROPERTY_TEXT.value).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).join((EntityPath)QOSPropertyText.O_S_PROPERTY_TEXT)).on((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(QOSPropertyText.O_S_PROPERTY_TEXT.id))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)this.entityName))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)this.entityId))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)key))).orderBy(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.desc())).fetch());
            return list.isEmpty() ? Optional.empty() : Optional.of(StringUtils.defaultString((String)((String)list.get(0))));
        }

        private Map<String, Object> bulkLoad(OfBizPropertyTypeRegistry.TypeMapper mapper) {
            return this.valuesByMapperEntityName.computeIfAbsent(mapper.getValueEntity(), mapperEntityName -> this.loadValues(this.entityName, this.entityId, mapper));
        }

        private Map<String, Object> loadValues(String entityName, long entityId, OfBizPropertyTypeRegistry.TypeMapper mapper) {
            List rows = (List)CachingOfBizPropertyEntryStore.this.query(db -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey, mapper.getValuePath()}).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).join(mapper.getValueTable())).on((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(mapper.getValueTable().getNumericIdPath()))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)entityName))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)entityId))).orderBy(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.desc())).fetch());
            return this.asMap(rows, mapper.getValuePath());
        }

        private <T> Map<String, T> asMap(List<Tuple> rows, Path<? extends T> valuePath) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)rows.size());
            rows.forEach(tuple -> {
                String key = (String)tuple.get((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey);
                if (!map.containsKey(key)) {
                    map.put(key, tuple.get((Expression)valuePath));
                }
            });
            return map;
        }
    }

    static class PropertyEntryImpl
    implements OfBizPropertyEntryStore.PropertyEntry {
        private final int type;
        private final Object value;

        PropertyEntryImpl(int type, @Nullable Object value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        @Nullable
        public Object getValue() {
            if (this.value == null) {
                return null;
            }
            return OfBizPropertyTypeRegistry.mapper(this.type).getHandler().processGet(this.type, this.value);
        }

        @Override
        @Nullable
        public Object getValue(int type) {
            if (this.value == null) {
                return null;
            }
            return OfBizPropertyTypeRegistry.mapper(type).getHandler().processGet(type, this.value);
        }

        public String toString() {
            return "PropertyEntryImpl[type=" + this.type + ",value=" + this.value + ']';
        }
    }

    static final class CacheKey
    implements Serializable {
        private static final long serialVersionUID = 4729043221678305211L;
        private final String entityName;
        private final long entityId;

        CacheKey(String entityName, long entityId) {
            this.entityName = entityName;
            this.entityId = entityId;
        }

        String getEntityName() {
            return this.entityName;
        }

        long getEntityId() {
            return this.entityId;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof CacheKey && this.equals((CacheKey)o);
        }

        private boolean equals(@Nonnull CacheKey other) {
            return this.entityId == other.entityId && this.entityName.equals(other.entityName);
        }

        public int hashCode() {
            int result = this.entityName.hashCode();
            result = 31 * result + (int)(this.entityId ^ this.entityId >>> 32);
            return result;
        }

        public String toString() {
            return "CacheKey[entityName=" + this.entityName + ",entityId=" + this.entityId + ']';
        }
    }
}

