/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.entity.WithIdFunctions;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionStore;
import com.atlassian.jira.util.NamedPredicates;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Longs;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@EventComponent
public class CachingVersionStore
implements VersionStore {
    private final VersionStore delegate;
    private final Cache<Long, Optional<Version>> versionById;
    private final CachedReference<List<Version>> allVersions;
    private final Cache<String, List<Version>> versionsByName;
    private final Cache<Long, List<Version>> versionsByProjectId;

    public CachingVersionStore(VersionStore delegate, CacheManager cacheManager) {
        this.delegate = delegate;
        this.versionById = cacheManager.getCache(this.getCacheReferenceName("versionById"), id -> Optional.fromNullable((Object)delegate.getVersion((Long)id)));
        this.allVersions = cacheManager.getCachedReference(this.getCacheReferenceName("allVersions"), () -> ImmutableList.copyOf(delegate.getAllVersions()));
        this.versionsByName = cacheManager.getCache(this.getCacheReferenceName("versionsByName"), name -> ImmutableList.copyOf(this.loadVersionsByName((String)name)));
        this.versionsByProjectId = cacheManager.getCache(this.getCacheReferenceName("versionsByProjectId"), projectId -> ImmutableList.copyOf(delegate.getVersionsByProject((Long)projectId)));
    }

    private String getCacheReferenceName(String name) {
        return CachingVersionStore.class.getCanonicalName() + ".cache." + name;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refreshCache(new long[0]);
    }

    @Override
    @Nonnull
    public Iterable<Version> getAllVersions() {
        return (Iterable)this.allVersions.get();
    }

    @Override
    public Version getVersion(Long id) {
        if (id == null) {
            return null;
        }
        Optional version = (Optional)this.versionById.get((Object)id);
        return version != null ? (Version)version.orNull() : null;
    }

    @Override
    @Nonnull
    public Version createVersion(@Nonnull Version version) {
        Version newVersion = this.delegate.createVersion(version);
        this.refreshCache(newVersion.getId());
        return newVersion;
    }

    @Override
    public void storeVersion(@Nonnull Version version) {
        this.delegate.storeVersion(version);
        this.refreshCache(version.getId());
    }

    @Override
    public void storeVersions(@Nonnull Collection<Version> versions) {
        this.delegate.storeVersions(versions);
        this.refreshCache(Longs.toArray((Collection)ImmutableList.copyOf((Iterable)Iterables.transform(versions, WithIdFunctions.getId()))));
    }

    @Override
    public void deleteVersion(@Nonnull Version version) {
        long versionId = version.getId();
        this.delegate.deleteVersion(version);
        this.refreshCache(versionId);
    }

    @Override
    public void deleteAllVersions(@Nonnull Long projectId) {
        this.delegate.deleteAllVersions(projectId);
        this.refreshCache(new long[0]);
    }

    @Override
    @Nonnull
    public Iterable<Version> getVersionsByName(String name) {
        List result = null;
        if (name != null) {
            result = (List)this.versionsByName.get((Object)name);
        }
        return result != null ? result : Collections.emptyList();
    }

    @Nonnull
    private Iterable<Version> loadVersionsByName(String name) {
        return Iterables.filter((Iterable)((Iterable)this.allVersions.get()), NamedPredicates.equalsIgnoreCase(name));
    }

    @Override
    @Nonnull
    public Iterable<Version> getVersionsByProject(Long projectId) {
        List result = null;
        if (projectId != null) {
            result = (List)this.versionsByProjectId.get((Object)projectId);
        }
        return result != null ? result : Collections.emptyList();
    }

    private void refreshCache(long ... versionIds) {
        if (versionIds.length > 0) {
            for (long versionId : versionIds) {
                this.versionById.remove((Object)versionId);
            }
        } else {
            this.versionById.removeAll();
        }
        this.allVersions.reset();
        this.versionsByName.removeAll();
        this.versionsByProjectId.removeAll();
    }
}

