/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.type;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.BrowseProjectTypeManager;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class BrowseProjectTypeManagerImpl
implements BrowseProjectTypeManager {
    private final ProjectTypeManager projectTypeManager;
    private final PermissionManager permissionManager;
    private static final String BUSINESS = "business";

    public BrowseProjectTypeManagerImpl(ProjectTypeManager projectTypeManager, PermissionManager permissionManager) {
        this.projectTypeManager = projectTypeManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public List<ProjectType> getAllProjectTypes(ApplicationUser user) {
        return this.getAllProjectTypesFor(this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user));
    }

    @Override
    public boolean isProjectTypeChangeAllowed(Project project) {
        ArrayList projects = Lists.newArrayList((Object[])new Project[]{project});
        return this.getAllProjectTypesFor(projects).size() > 1;
    }

    private List<ProjectType> getAllProjectTypesFor(Collection<Project> projects) {
        Stream<ProjectType> installedProjectTypes = this.getProjectTypes(this.projectTypeManager.getAllAccessibleProjectTypes());
        Stream<ProjectType> projectTypesOfProjects = this.getProjectTypes(projects);
        ProjectType businessProjectType = this.getProjectTypeFor(new ProjectTypeKey(BUSINESS));
        return (List)Stream.concat(installedProjectTypes, Stream.concat(projectTypesOfProjects, Stream.of(businessProjectType))).distinct().sorted(Comparator.comparingInt(ProjectType::getWeight)).collect(CollectorsUtil.toImmutableList());
    }

    private Stream<ProjectType> getProjectTypes(Collection<Project> projects) {
        return this.getUniqueProjectTypes(projects.stream().map(Project::getProjectTypeKey));
    }

    private Stream<ProjectType> getProjectTypes(List<ProjectType> projectTypes) {
        return this.getUniqueProjectTypes(projectTypes.stream().map(ProjectType::getKey));
    }

    private Stream<ProjectType> getUniqueProjectTypes(Stream<ProjectTypeKey> projectTypeKeySet) {
        return projectTypeKeySet.distinct().map(this::getProjectTypeFor);
    }

    private ProjectType getProjectTypeFor(ProjectTypeKey key) {
        return (ProjectType)this.projectTypeManager.getByKey(key).getOr(() -> this.getInaccessibleProjectType(key));
    }

    private ProjectType getInaccessibleProjectType(ProjectTypeKey projectTypeKey) {
        ProjectType inaccessibleProjectType = this.projectTypeManager.getInaccessibleProjectType();
        return new ProjectType(projectTypeKey, inaccessibleProjectType.getDescriptionI18nKey(), inaccessibleProjectType.getIcon(), inaccessibleProjectType.getColor(), inaccessibleProjectType.getWeight());
    }
}

