/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.archiving;

import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import java.util.stream.StreamSupport;

public class ArchivingLicenseCheck {
    public static final String DATA_CENTER_FAKE_PROPERTY_KEY = "com.atlassian.jira.project.archiving.dc.only";
    public static final String DATA_CENTER_FAKE_PROPERTY_VALUE = "bypass";
    private final ClusterManager clusterManager;
    private final JiraLicenseManager jiraLicenseManager;
    private final FeatureManager featureManager;
    private final JiraProperties jiraProperties;

    public ArchivingLicenseCheck(ClusterManager clusterManager, JiraLicenseManager jiraLicenseManager, FeatureManager featureManager, JiraProperties jiraProperties) {
        this.clusterManager = clusterManager;
        this.jiraLicenseManager = jiraLicenseManager;
        this.featureManager = featureManager;
        this.jiraProperties = jiraProperties;
    }

    public boolean isLicensedForIssueArchiving() {
        return this.jiraProperties.isDevMode() || this.isLicensedForArchiving() && this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ISSUE_ARCHIVING);
    }

    public boolean isLicensedForProjectArchiving() {
        return this.jiraProperties.isDevMode() || this.isLicensedForArchiving() && this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PROJECT_ARCHIVING);
    }

    public boolean isLicensedForArchiving() {
        return this.hasAnyLicenseBypassProperty() || this.clusterManager.isClusterLicensed();
    }

    private boolean hasAnyLicenseBypassProperty() {
        return StreamSupport.stream(this.jiraLicenseManager.getLicenses().spliterator(), false).map(LicenseDetails::getJiraLicense).anyMatch(this::hasBypassProperty);
    }

    private boolean hasBypassProperty(JiraLicense license) {
        return DATA_CENTER_FAKE_PROPERTY_VALUE.equals(license.getProperty(DATA_CENTER_FAKE_PROPERTY_KEY));
    }
}

