/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.archiving.ArchivedProjectManager;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

public class ProjectImpl
implements Project {
    private final GenericValue projectGV;
    private final String key;
    private final Long id;
    private ApplicationUser lead;

    public ProjectImpl(GenericValue projectGv) {
        this.projectGV = projectGv;
        this.key = this.getStringFromGV("key");
        this.id = this.getLongFromGV("id");
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.getStringFromGV("name");
    }

    public String getKey() {
        return this.key;
    }

    public String getUrl() {
        return this.getStringFromGV("url");
    }

    public String getEmail() {
        return OFBizPropertyUtils.getPropertySet(this.projectGV).getString("jira.project.email.sender");
    }

    public ApplicationUser getProjectLead() {
        return ComponentAccessor.getUserManager().getUserByKey(this.getLeadUserKey());
    }

    public ApplicationUser getLead() {
        if (this.getLeadUserName() != null && this.lead == null) {
            this.lead = this.getUser(this.getLeadUserName());
        }
        return this.lead;
    }

    public String getLeadUserName() {
        ApplicationUser lead = this.getProjectLead();
        if (lead == null) {
            return this.getLeadUserKey();
        }
        return lead.getUsername();
    }

    public String getLeadUserKey() {
        return this.getStringFromGV("lead");
    }

    public String getOriginalKey() {
        return this.getStringFromGV("originalkey");
    }

    public boolean isArchived() {
        return ((ArchivedProjectManager)ComponentAccessor.getComponent(ArchivedProjectManager.class)).isProjectArchived(this);
    }

    public String getDescription() {
        String value = this.getStringFromGV("description");
        return value == null ? "" : value;
    }

    public Long getAssigneeType() {
        return this.getLongFromGV("assigneetype");
    }

    public ProjectTypeKey getProjectTypeKey() {
        return new ProjectTypeKey(this.getStringFromGV("projecttype"));
    }

    public Collection<ProjectComponent> getComponents() {
        return ComponentAccessor.getProjectComponentManager().findAllForProject(this.getId());
    }

    public Collection<ProjectComponent> getProjectComponents() {
        return this.getComponents();
    }

    public Collection<Version> getVersions() {
        return ComponentAccessor.getVersionManager().getVersions(this.projectGV.getLong("id"));
    }

    public Collection<IssueType> getIssueTypes() {
        return ((IssueTypeSchemeManager)ComponentAccessor.getComponent(IssueTypeSchemeManager.class)).getIssueTypesForProject((Project)this);
    }

    public ProjectCategory getProjectCategory() {
        return ComponentAccessor.getProjectManager().getProjectCategoryForProject((Project)this);
    }

    public ProjectCategory getProjectCategoryObject() {
        return this.getProjectCategory();
    }

    @Nonnull
    public Avatar getAvatar() {
        AvatarManager avatarManager = ComponentAccessor.getAvatarManager();
        Avatar projectAvatar = avatarManager.getById(this.getLongFromGV("avatar"));
        if (null == projectAvatar) {
            Avatar defaultAvatar = avatarManager.getDefaultAvatar(IconType.PROJECT_ICON_TYPE);
            if (null == defaultAvatar) {
                throw new NoSuchElementException("There is no project default avatar - configuration failure!");
            }
            return defaultAvatar;
        }
        return projectAvatar;
    }

    public GenericValue getGenericValue() {
        return this.projectGV;
    }

    private String getStringFromGV(String key) {
        if (this.projectGV != null) {
            return this.projectGV.getString(key);
        }
        return null;
    }

    private Long getLongFromGV(String key) {
        if (this.projectGV != null) {
            return this.projectGV.getLong(key);
        }
        return null;
    }

    private ApplicationUser getUser(String username) {
        return UserUtils.getUserEvenWhenUnknown((String)username);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (this.getId() == null) {
            return other.getId() == null;
        }
        return this.getId().equals(other.getId());
    }

    public int hashCode() {
        Long id = this.getId();
        return id != null ? id.hashCode() : 0;
    }

    public String toString() {
        return "Project: " + this.getKey();
    }
}

