/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.bc.dataimport.DataImportFinishedEvent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import org.apache.commons.lang3.math.NumberUtils;

public class SuperBatchInvalidator
implements InitializingComponent {
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;

    public SuperBatchInvalidator(ApplicationProperties applicationProperties, EventPublisher eventPublisher) {
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void afterInstantiation() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void pluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.incrementSuperbatchVersionIfJiraNotSetup();
    }

    @EventListener
    public void dataImportFinished(DataImportFinishedEvent ignore) {
        this.incrementSuperbatchVersionIfJiraNotSetup();
    }

    private void incrementSuperbatchVersionIfJiraNotSetup() {
        if (this.applicationProperties.getString("jira.setup") == null) {
            this.incrementSuperbatchVersion();
        }
    }

    private void incrementSuperbatchVersion() {
        String versionString = this.getSuperBatchVersion();
        Long superbatchVersion = NumberUtils.toLong((String)versionString, (long)1L);
        this.applicationProperties.setString("jira.webresource.superbatch.flushcounter", Long.toString(superbatchVersion + 1L));
    }

    private String getSuperBatchVersion() {
        return this.applicationProperties.getDefaultBackedString("jira.webresource.superbatch.flushcounter");
    }
}

