/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat;

import com.atlassian.jira.plugin.profile.UserFormat;
import com.atlassian.jira.plugin.userformat.UserFormatter;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.Map;

public class UserFormatterImpl
implements UserFormatter {
    private final UserFormat userFormat;
    private final UserKeyService userKeyService;

    public UserFormatterImpl(UserFormat userFormat, UserKeyService userKeyService) {
        this.userFormat = (UserFormat)Assertions.notNull((String)"userFormat", (Object)userFormat);
        this.userKeyService = (UserKeyService)Assertions.notNull((String)"userKeyService", (Object)userKeyService);
    }

    @HtmlSafe
    public String formatUserkey(String userkey, String id) {
        return this.userFormat.format(userkey, id);
    }

    @HtmlSafe
    public String formatUserkey(String userkey, String id, Map<String, Object> params) {
        return this.userFormat.format(userkey, id, params);
    }

    @HtmlSafe
    public String formatUsername(String username, String id) {
        return this.userFormat.format(this.userKeyService.getKeyForUsername(username), id);
    }

    @HtmlSafe
    public String formatUsername(String username, String id, Map<String, Object> params) {
        return this.userFormat.format(this.userKeyService.getKeyForUsername(username), id, params);
    }
}

