/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat;

import com.atlassian.jira.plugin.profile.UserFormat;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FullNameUserFormat
implements UserFormat {
    public static final String TYPE = "fullName";
    private final UserManager userManager;
    private final UserUtil userUtil;

    public FullNameUserFormat(UserManager userManager, UserUtil userUtil) {
        this.userManager = userManager;
        this.userUtil = userUtil;
    }

    @HtmlSafe
    public String format(String key, String id) {
        return this.format(key, id, null);
    }

    @HtmlSafe
    public String format(String key, String id, Map<String, Object> params) {
        Boolean escape;
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        ApplicationUser user = this.userManager.getUserByKeyEvenWhenUnknown(key);
        String formattedUser = this.userUtil.getDisplayableNameSafely(user);
        Boolean bl = escape = params != null ? (Boolean)params.get("escape") : null;
        if (escape != null && !escape.booleanValue()) {
            return formattedUser;
        }
        return TextUtils.htmlEncode((String)formattedUser);
    }
}

