/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.permission;

import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.permission.DefaultProjectPermission;
import com.atlassian.jira.plugin.permission.ProjectPermissionModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.descriptors.ConditionDescriptorFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.atlassian.plugin.web.Condition;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collection;
import org.dom4j.Element;

public class ProjectPermissionModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<ProjectPermission>
implements ProjectPermissionModuleDescriptor {
    private static final String SYSTEM_PLUGIN_KEY = "jira.system.project.permissions";
    private ProjectPermissionCategory category;
    private Condition condition;
    private ConditionDescriptorFactory conditionDescriptorFactory;
    private String descriptionI18nKey;
    private Element element;

    public ProjectPermissionModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory, ConditionDescriptorFactory conditionDescriptorFactory) {
        super(authenticationContext, moduleFactory);
        this.conditionDescriptorFactory = conditionDescriptorFactory;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        if (this.systemPermissionOverride(plugin)) {
            throw new PluginParseException("Plugin '" + plugin.getKey() + "' cannot override system project permission '" + this.getKey() + "'");
        }
        this.descriptionI18nKey = element.attributeValue("i18n-description-key");
        this.element = element;
        this.initCategory(element);
    }

    @Override
    public void enabled() {
        super.enabled();
        if (this.condition == null) {
            this.condition = this.conditionDescriptorFactory.retrieveCondition(this.plugin, this.element);
            this.element = null;
        }
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@i18n-name-key").withError("The 'i18n-name-key' attribute is required for project permission module descriptors")});
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@category").withError("The 'category' attribute is required for project permission module descriptors")});
    }

    private boolean systemPermissionOverride(Plugin plugin) {
        return !SYSTEM_PLUGIN_KEY.equals(plugin.getKey()) && ProjectPermissionModuleDescriptorImpl.systemProjectPermissionKeys().contains(new ProjectPermissionKey(this.getKey()));
    }

    public static Collection<ProjectPermissionKey> systemProjectPermissionKeys() {
        return Arrays.asList(ProjectPermissions.ADMINISTER_PROJECTS, ProjectPermissions.BROWSE_PROJECTS, ProjectPermissions.VIEW_READONLY_WORKFLOW, ProjectPermissions.CREATE_ISSUES, ProjectPermissions.EDIT_ISSUES, ProjectPermissions.TRANSITION_ISSUES, ProjectPermissions.SCHEDULE_ISSUES, ProjectPermissions.MOVE_ISSUES, ProjectPermissions.ASSIGN_ISSUES, ProjectPermissions.ASSIGNABLE_USER, ProjectPermissions.RESOLVE_ISSUES, ProjectPermissions.CLOSE_ISSUES, ProjectPermissions.MODIFY_REPORTER, ProjectPermissions.DELETE_ISSUES, ProjectPermissions.ARCHIVE_ISSUES, ProjectPermissions.RESTORE_ISSUES, ProjectPermissions.LINK_ISSUES, ProjectPermissions.SET_ISSUE_SECURITY, ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, ProjectPermissions.MANAGE_WATCHERS, ProjectPermissions.ADD_COMMENTS, ProjectPermissions.EDIT_ALL_COMMENTS, ProjectPermissions.EDIT_OWN_COMMENTS, ProjectPermissions.DELETE_ALL_COMMENTS, ProjectPermissions.DELETE_OWN_COMMENTS, ProjectPermissions.CREATE_ATTACHMENTS, ProjectPermissions.DELETE_ALL_ATTACHMENTS, ProjectPermissions.DELETE_OWN_ATTACHMENTS, ProjectPermissions.WORK_ON_ISSUES, ProjectPermissions.EDIT_OWN_WORKLOGS, ProjectPermissions.EDIT_ALL_WORKLOGS, ProjectPermissions.DELETE_OWN_WORKLOGS, ProjectPermissions.DELETE_ALL_WORKLOGS);
    }

    private void initCategory(Element element) throws PluginParseException {
        String categoryKey = element.attributeValue("category");
        for (ProjectPermissionCategory category : ProjectPermissionCategory.values()) {
            if (!category.name().equalsIgnoreCase(categoryKey)) continue;
            this.category = category;
            return;
        }
        throw new PluginParseException("Invalid project permission category key '" + categoryKey + "'. Allowed values: " + Joiner.on((String)", ").join((Object[])ProjectPermissionCategory.values()));
    }

    @Override
    protected ProjectPermission createModule() {
        return new DefaultProjectPermission(this.getKey(), this.getI18nNameKey(), this.descriptionI18nKey, this.category, this.condition);
    }
}

