/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.vote.VotedIssuesAccessor;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

public class VotedIssuesFunction
extends AbstractJqlFunction {
    public static final String FUNCTION_VOTED_ISSUES = "votedIssues";
    private final VotedIssuesAccessor voterAccessor;

    public VotedIssuesFunction(VotedIssuesAccessor voterAccessor) {
        this.voterAccessor = (VotedIssuesAccessor)Assertions.notNull((String)"voterAccessor", (Object)voterAccessor);
    }

    public MessageSet validate(ApplicationUser searcher, FunctionOperand operand, TerminalClause terminalClause) {
        MessageSetImpl messageSet;
        if (!this.voterAccessor.isVotingEnabled()) {
            messageSet = new MessageSetImpl();
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.voted.issues.disabled", this.getFunctionName()));
        } else if (searcher == null) {
            messageSet = new MessageSetImpl();
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.anonymous.disallowed", this.getFunctionName()));
        } else {
            messageSet = this.validateNumberOfArgs(operand, 0);
        }
        return messageSet;
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        Assertions.notNull((String)"queryCreationContext", (Object)queryCreationContext);
        if (queryCreationContext.getQueryUser() == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Iterable)Transformed.iterable(this.getVotedIssues(queryCreationContext.getQueryUser(), queryCreationContext.isSecurityOverriden()), votedIssue -> new QueryLiteral((Operand)operand, votedIssue)));
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.ISSUE;
    }

    Iterable<Long> getVotedIssues(ApplicationUser searcher, boolean overrideSecurity) {
        VotedIssuesAccessor.Security security = overrideSecurity ? VotedIssuesAccessor.Security.OVERRIDE : VotedIssuesAccessor.Security.RESPECT;
        return this.voterAccessor.getVotedIssueIds(searcher, searcher, security);
    }
}

